/*
 * Decompiled with CFR 0.152.
 */
package com.kevsterking.imagemod.neoforge.ImageBuilder;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;

public class ImageUtil {
    private static BufferedImage format_image(BufferedImage input_image, int width, int height) {
        if (input_image.getHeight() != height || input_image.getWidth() != width || input_image.getType() != 6) {
            BufferedImage formatted = new BufferedImage(width, height, 6);
            Graphics2D g = formatted.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.drawImage(input_image, 0, 0, width, height, null);
            g.dispose();
            return formatted;
        }
        return input_image;
    }

    public static BufferedImage load(BufferedImage img, int width, int height) {
        return ImageUtil.format_image(img, width, height);
    }

    public static BufferedImage load_width(BufferedImage img, int width) {
        return ImageUtil.format_image(img, width, width * img.getHeight() / img.getWidth());
    }

    public static BufferedImage load_height(BufferedImage img, int height) {
        return ImageUtil.format_image(img, height * img.getWidth() / img.getHeight(), height);
    }
}

