/*
 * Decompiled with CFR 0.152.
 */
package com.kevsterking.imagemod.neoforge.commands;

import com.kevsterking.imagemod.neoforge.ImageBuilder.ImageBlock;
import com.kevsterking.imagemod.neoforge.ImageBuilder.Mosaic.MosaicIntColThread;
import com.kevsterking.imagemod.neoforge.ImageModClient;
import com.kevsterking.imagemod.neoforge.WorldTransformer.WorldStructure;
import com.kevsterking.imagemod.neoforge.WorldTransformer.WorldTransformer;
import com.kevsterking.imagemod.neoforge.util.DirectoryArgument;
import com.kevsterking.imagemod.neoforge.util.ImageFileArgument;
import com.kevsterking.imagemod.neoforge.util.PathArgument;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class ImageCommand {
    private final PathArgument image_argument = new ImageFileArgument();
    private final PathArgument directory_argument = new DirectoryArgument();
    private final ArrayList<ImageBlock> image_blocks = new ArrayList();
    private final MosaicIntColThread image_builder = new MosaicIntColThread();
    private WorldTransformer world_transformer;

    public void update_block_list() {
        ImageModClient.LOGGER.info("Loading block list");
        for (Block block : BuiltInRegistries.BLOCK.stream().toList()) {
            try {
                if (!ImageBlock.filter_block(block)) continue;
                this.image_blocks.add(ImageBlock.get(block));
                ImageModClient.LOGGER.debug("{} - ACCEPTED", (Object)block.getName().getString());
            }
            catch (Exception e) {
                ImageModClient.LOGGER.debug("{} - REJECTED: {}", (Object)block.getName().getString(), (Object)e.getMessage());
            }
        }
        this.image_blocks.add(ImageBlock.get_air());
        ImageBlock[] blocks = new ImageBlock[this.image_blocks.size()];
        for (int i = 0; i < this.image_blocks.size(); ++i) {
            blocks[i] = this.image_blocks.get(i);
        }
        this.image_builder.set_tiles(blocks, 16);
        ImageModClient.LOGGER.info("Block list loading complete.");
    }

    private int create_execute(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        int h;
        int w;
        Minecraft client = Minecraft.getInstance();
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        if (client.getSingleplayerServer() == null) {
            source.sendFailure((Component)Component.literal((String)"Failed: Multiplayer image creation coming soon..."));
            return 0;
        }
        Level level = source.getUnsidedLevel();
        Entity entity = source.getEntity();
        if (entity == null) {
            source.sendFailure((Component)Component.literal((String)"Failed: Source is not an entity"));
            return 0;
        }
        Direction direction_view = entity.getDirection();
        Direction direction_right = direction_view.getClockWise();
        BlockPos position = entity.blockPosition().relative(direction_view, 2);
        int input_width = 0;
        int input_height = 0;
        boolean width_set = false;
        boolean height_set = false;
        try {
            input_width = IntegerArgumentType.getInteger(ctx, (String)"width");
            width_set = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            input_height = IntegerArgumentType.getInteger(ctx, (String)"height");
            height_set = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        Path path = this.image_argument.get_path(ctx, "src");
        BufferedImage image = null;
        try {
            image = ImageIO.read(path.toFile());
        }
        catch (IOException e) {
            throw new SimpleCommandExceptionType((Message)Component.literal((String)"Failed: Could not load image.")).create();
        }
        if (image == null) {
            throw new SimpleCommandExceptionType((Message)Component.literal((String)"Failed: Could not load image.")).create();
        }
        if (width_set && height_set) {
            w = input_width;
            h = input_height;
        } else if (width_set) {
            w = input_width;
            h = (int)((double)input_width * ((double)image.getHeight() / (double)image.getWidth()));
        } else if (height_set) {
            h = input_height;
            w = (int)((double)input_height * ((double)image.getWidth() / (double)image.getHeight()));
        } else {
            throw new SimpleCommandExceptionType((Message)Component.literal((String)"Failed: No width or height set.")).create();
        }
        this.image_builder.generate_async(image, w, h, structure -> {
            try {
                this.world_transformer.place_async(level, (WorldStructure)structure, position, direction_right, Direction.UP, direction_view, v -> {
                    source.sendSuccess(() -> Component.literal((String)String.format("Successfully created %dx%d image", w, h)), false);
                    return null;
                });
            }
            catch (Exception e) {
                source.sendFailure((Component)Component.literal((String)("Failed: " + e.getMessage())));
                return null;
            }
            return null;
        });
        return 1;
    }

    private int reload_execute(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        this.update_block_list();
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"Reloaded block list"), false);
        return 1;
    }

    private int undo_execute(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        this.world_transformer.undo_async(e -> {
            if (e != null) {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)("Failed: " + e.getMessage())));
                return null;
            }
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"Successfully reverted last WorldTransform"), false);
            return null;
        });
        return 1;
    }

    private int redo_execute(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        this.world_transformer.redo_async(e -> {
            if (e != null) {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)("Failed: " + e.getMessage())));
                return null;
            }
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"Successful redo of last undone WorldTransform"), false);
            return null;
        });
        return 1;
    }

    private int set_directory_execute(CommandContext<CommandSourceStack> ctx) {
        Path dir = this.directory_argument.get_path(ctx, "dir");
        try {
            this.image_argument.set_root_directory(dir.toString());
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("Successfully set image directory to \"" + String.valueOf(dir) + "\"")), false);
            return 1;
        }
        catch (NotDirectoryException e) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"Provided path is not a directory"));
        }
        catch (FileNotFoundException e) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"Provided path could not be found"));
        }
        return 0;
    }

    public void register(CommandDispatcher<CommandSourceStack> ctx) {
        ImageModClient.LOGGER.info("Registering Commands...");
        this.world_transformer = new WorldTransformer();
        this.update_block_list();
        LiteralArgumentBuilder root = Commands.literal((String)"image");
        LiteralArgumentBuilder createLiteral = Commands.literal((String)"create");
        LiteralArgumentBuilder wLiteral = Commands.literal((String)"-width");
        LiteralArgumentBuilder hLiteral = Commands.literal((String)"-height");
        LiteralArgumentBuilder whInfoLiteral = Commands.literal((String)"~ ~");
        RequiredArgumentBuilder srcArgument = Commands.argument((String)"src", (ArgumentType)this.image_argument);
        RequiredArgumentBuilder wArgument = Commands.argument((String)"width", (ArgumentType)IntegerArgumentType.integer());
        RequiredArgumentBuilder wArgumentFinal = (RequiredArgumentBuilder)Commands.argument((String)"width", (ArgumentType)IntegerArgumentType.integer()).executes(this::create_execute);
        RequiredArgumentBuilder hArgumentFinal = (RequiredArgumentBuilder)Commands.argument((String)"height", (ArgumentType)IntegerArgumentType.integer()).executes(this::create_execute);
        wLiteral.then((ArgumentBuilder)wArgumentFinal);
        hLiteral.then((ArgumentBuilder)hArgumentFinal);
        wArgument.then((ArgumentBuilder)hArgumentFinal);
        ((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)srcArgument.then((ArgumentBuilder)wLiteral)).then((ArgumentBuilder)hLiteral)).then((ArgumentBuilder)whInfoLiteral)).then((ArgumentBuilder)wArgument);
        createLiteral.then((ArgumentBuilder)srcArgument);
        LiteralArgumentBuilder reload = (LiteralArgumentBuilder)Commands.literal((String)"reload").executes(this::reload_execute);
        LiteralArgumentBuilder undoLiteral = (LiteralArgumentBuilder)Commands.literal((String)"undo").executes(this::undo_execute);
        LiteralArgumentBuilder redoLiteral = (LiteralArgumentBuilder)Commands.literal((String)"redo").executes(this::redo_execute);
        LiteralArgumentBuilder setDirectoryLiteral = Commands.literal((String)"setDirectory");
        RequiredArgumentBuilder directoryArgument = (RequiredArgumentBuilder)Commands.argument((String)"dir", (ArgumentType)this.directory_argument).executes(this::set_directory_execute);
        setDirectoryLiteral.then((ArgumentBuilder)directoryArgument);
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)root.then((ArgumentBuilder)createLiteral)).then((ArgumentBuilder)setDirectoryLiteral)).then((ArgumentBuilder)reload)).then((ArgumentBuilder)undoLiteral)).then((ArgumentBuilder)redoLiteral);
        ctx.register(root);
        ImageModClient.LOGGER.info("Commands Registered.");
    }
}

