/*
 * Decompiled with CFR 0.152.
 */
package com.kevsterking.imagemod.neoforge.util;

import com.kevsterking.imagemod.neoforge.util.PathArgument;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public class DirectoryArgument
extends PathArgument {
    private static final SimpleCommandExceptionType NOT_DIRECTORY = new SimpleCommandExceptionType((Message)new LiteralMessage("Path not found"));

    @Override
    public boolean filter_path(Path path) {
        try {
            if (Files.isDirectory(path, new LinkOption[0])) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public Path parse(StringReader reader) throws CommandSyntaxException {
        Path ret = super.parse(reader);
        if (!ret.toFile().isDirectory()) {
            throw NOT_DIRECTORY.createWithContext((ImmutableStringReader)reader);
        }
        return ret;
    }
}

