/*
 * Decompiled with CFR 0.152.
 */
package com.kevsterking.imagemod.neoforge.util;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.FileNotFoundException;
import java.nio.file.Files;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.commands.CommandSourceStack;

public class PathArgument
implements ArgumentType<Path> {
    private static final Collection<String> EXAMPLES = Arrays.asList("\"" + System.getProperty("user.home") + "/Downloads\"", "\"" + System.getProperty("user.home") + "/Desktop\"");
    private static final SimpleCommandExceptionType PATH_NOT_FOUND = new SimpleCommandExceptionType((Message)new LiteralMessage("Path not found"));
    public static Path root_directory = PathArgument.get_default_path();

    public static String clean_path_string(String path) {
        return path.replace("\\", "/");
    }

    private static Path get_default_path() {
        return Paths.get(System.getProperty("user.home") + "/Downloads/", new String[0]);
    }

    public Path get_directory(Path path) throws FileNotFoundException, NotDirectoryException {
        Path dir = this.get_path(path);
        if (!dir.toFile().isDirectory()) {
            throw new NotDirectoryException(path.toFile().getPath());
        }
        return dir;
    }

    public Path get_directory(String str) throws FileNotFoundException, NotDirectoryException {
        return this.get_directory(Paths.get(str, new String[0]));
    }

    public Path get_path(Path path) throws FileNotFoundException {
        Path ret;
        Path path2 = ret = root_directory != null ? root_directory.resolve(path) : path;
        if (ret.toFile().exists()) {
            return ret;
        }
        if (path.toFile().exists()) {
            return path;
        }
        throw new FileNotFoundException();
    }

    public Path get_path(String str) throws FileNotFoundException {
        return this.get_path(Paths.get(PathArgument.clean_path_string(str), new String[0]));
    }

    public Path get_path(CommandContext<CommandSourceStack> context, String name) {
        return (Path)context.getArgument(name, Path.class);
    }

    public void set_root_directory(String path) throws NotDirectoryException, FileNotFoundException {
        root_directory = this.get_directory(path);
    }

    public Path parse(StringReader reader) throws CommandSyntaxException {
        try {
            return this.get_path(StringArgumentType.string().parse(reader));
        }
        catch (FileNotFoundException e) {
            throw PATH_NOT_FOUND.createWithContext((ImmutableStringReader)reader);
        }
    }

    private String get_formatted_path(Path path) {
        Path p = path.startsWith(root_directory) ? root_directory.relativize(path) : path;
        return PathArgument.clean_path_string(p.toString()) + (path.toFile().isDirectory() ? "/" : "");
    }

    public boolean filter_path(Path path) {
        return true;
    }

    private String argument_format(Path path) {
        String path_str = this.get_formatted_path(path);
        try {
            if (StringArgumentType.string().parse(new StringReader(path_str)).compareTo(path_str) != 0) {
                throw new Exception();
            }
            return path_str;
        }
        catch (Exception e) {
            return "\"" + path_str + "\"";
        }
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        StringReader stringReader = new StringReader(builder.getInput());
        stringReader.setCursor(builder.getStart());
        try {
            String parsed = StringArgumentType.string().parse(stringReader);
            int i = parsed.lastIndexOf("/") + 1;
            String query = parsed.substring(i);
            Path directory = this.get_directory(parsed.substring(0, i));
            try (Stream<Path> paths = Files.list(directory);){
                paths.filter(path -> path.getFileName().toString().indexOf(query) == 0).filter(this::filter_path).forEach(path -> builder.suggest(this.argument_format((Path)path)));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return builder.buildFuture();
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

