/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.sundriesbydonjey.init;

import net.mcreator.sundriesbydonjey.entity.ScallopEntity;
import net.mcreator.sundriesbydonjey.entity.ThinkerEntity;
import net.mcreator.sundriesbydonjey.entity.WraithEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class SundriesModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"sundries");
    public static final RegistryObject<EntityType<WraithEntity>> WRAITH = SundriesModEntities.register("wraith", EntityType.Builder.m_20704_(WraithEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(WraithEntity::new).m_20699_(0.6f, 1.8f));
    public static final RegistryObject<EntityType<ThinkerEntity>> THINKER = SundriesModEntities.register("thinker", EntityType.Builder.m_20704_(ThinkerEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(ThinkerEntity::new).m_20699_(0.6f, 1.8f));
    public static final RegistryObject<EntityType<ScallopEntity>> SCALLOP = SundriesModEntities.register("scallop", EntityType.Builder.m_20704_(ScallopEntity::new, (MobCategory)MobCategory.WATER_CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(ScallopEntity::new).m_20699_(0.6f, 1.8f));

    private static <T extends Entity> RegistryObject<EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.m_20712_(registryname));
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            WraithEntity.init();
            ThinkerEntity.init();
            ScallopEntity.init();
        });
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)WRAITH.get(), WraithEntity.createAttributes().m_22265_());
        event.put((EntityType)THINKER.get(), ThinkerEntity.createAttributes().m_22265_());
        event.put((EntityType)SCALLOP.get(), ScallopEntity.createAttributes().m_22265_());
    }
}

