/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.sundriesbydonjey.init;

import net.mcreator.sundriesbydonjey.entity.ScallopEntity;
import net.mcreator.sundriesbydonjey.entity.ThinkerEntity;
import net.mcreator.sundriesbydonjey.entity.WraithEntity;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class SundriesModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"sundries");
    public static final DeferredHolder<EntityType<?>, EntityType<WraithEntity>> WRAITH = SundriesModEntities.register("wraith", EntityType.Builder.of(WraithEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<ThinkerEntity>> THINKER = SundriesModEntities.register("thinker", EntityType.Builder.of(ThinkerEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<ScallopEntity>> SCALLOP = SundriesModEntities.register("scallop", EntityType.Builder.of(ScallopEntity::new, (MobCategory)MobCategory.WATER_CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.8f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(registryname));
    }

    @SubscribeEvent
    public static void init(RegisterSpawnPlacementsEvent event) {
        WraithEntity.init(event);
        ThinkerEntity.init(event);
        ScallopEntity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)WRAITH.get(), WraithEntity.createAttributes().build());
        event.put((EntityType)THINKER.get(), ThinkerEntity.createAttributes().build());
        event.put((EntityType)SCALLOP.get(), ScallopEntity.createAttributes().build());
    }
}

