/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.sundriesbydonjey.item;

import com.google.common.collect.Iterables;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.mcreator.sundriesbydonjey.init.SundriesModItems;
import net.mcreator.sundriesbydonjey.procedures.RoseGoldChestplateTickEventProcedure;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.RegisterEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public abstract class RoseGoldItem
extends ArmorItem {
    public static Holder<ArmorMaterial> ARMOR_MATERIAL = null;

    @SubscribeEvent
    public static void registerArmorMaterial(RegisterEvent event) {
        event.register(Registries.ARMOR_MATERIAL, registerHelper -> {
            ArmorMaterial armorMaterial = new ArmorMaterial((Map)Util.make(new EnumMap(ArmorItem.Type.class), map -> {
                map.put(ArmorItem.Type.BOOTS, 1);
                map.put(ArmorItem.Type.LEGGINGS, 4);
                map.put(ArmorItem.Type.CHESTPLATE, 5);
                map.put(ArmorItem.Type.HELMET, 2);
                map.put(ArmorItem.Type.BODY, 5);
            }), 9, (Holder)DeferredHolder.create((ResourceKey)Registries.SOUND_EVENT, (ResourceLocation)ResourceLocation.parse((String)"item.armor.equip_gold")), () -> Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)SundriesModItems.ROSE_GOLD_INGOT.get())}), List.of(new ArmorMaterial.Layer(ResourceLocation.parse((String)"sundries:rose_gold_"))), 0.0f, 0.0f);
            registerHelper.register(ResourceLocation.parse((String)"sundries:rose_gold"), (Object)armorMaterial);
            ARMOR_MATERIAL = BuiltInRegistries.ARMOR_MATERIAL.wrapAsHolder((Object)armorMaterial);
        });
    }

    public RoseGoldItem(ArmorItem.Type type, Item.Properties properties) {
        super(ARMOR_MATERIAL, type, properties);
    }

    public static class Boots
    extends RoseGoldItem {
        public Boots() {
            super(ArmorItem.Type.BOOTS, new Item.Properties().durability(ArmorItem.Type.BOOTS.getDurability(25)));
        }
    }

    public static class Leggings
    extends RoseGoldItem {
        public Leggings() {
            super(ArmorItem.Type.LEGGINGS, new Item.Properties().durability(ArmorItem.Type.LEGGINGS.getDurability(25)));
        }
    }

    public static class Chestplate
    extends RoseGoldItem {
        public Chestplate() {
            super(ArmorItem.Type.CHESTPLATE, new Item.Properties().durability(ArmorItem.Type.CHESTPLATE.getDurability(25)));
        }

        public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
            Player player;
            super.inventoryTick(itemstack, world, entity, slot, selected);
            if (entity instanceof Player && Iterables.contains((Iterable)(player = (Player)entity).getArmorSlots(), (Object)itemstack)) {
                RoseGoldChestplateTickEventProcedure.execute(entity);
            }
        }
    }

    public static class Helmet
    extends RoseGoldItem {
        public Helmet() {
            super(ArmorItem.Type.HELMET, new Item.Properties().durability(ArmorItem.Type.HELMET.getDurability(25)));
        }
    }
}

