/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.properties.types;

import ch.jalu.configme.internal.ConversionUtils;
import ch.jalu.configme.properties.convertresult.ConvertErrorRecorder;
import ch.jalu.configme.properties.types.PropertyType;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrayPropertyType<T>
implements PropertyType<T[]> {
    private final PropertyType<T> entryType;
    private final IntFunction<T[]> arrayProducer;

    public ArrayPropertyType(@NotNull PropertyType<T> entryType, @NotNull IntFunction<T[]> arrayProducer) {
        Objects.requireNonNull(entryType, "entryType");
        Objects.requireNonNull(arrayProducer, "arrayProducer");
        this.entryType = entryType;
        this.arrayProducer = arrayProducer;
    }

    @Override
    public T @Nullable [] convert(@Nullable Object object, @NotNull ConvertErrorRecorder errorRecorder) {
        if (object instanceof Collection) {
            Collection coll = (Collection)object;
            return coll.stream().map(elem -> ConversionUtils.convertOrLogError(elem, this.entryType, errorRecorder)).filter(Objects::nonNull).toArray(this.arrayProducer);
        }
        return null;
    }

    @NotNull
    public List<?> toExportValue(T @NotNull [] value) {
        return Arrays.stream(value).map(this.entryType::toExportValue).collect(Collectors.toList());
    }

    @NotNull
    public final PropertyType<T> getEntryType() {
        return this.entryType;
    }

    @NotNull
    public final IntFunction<T[]> getArrayProducer() {
        return this.arrayProducer;
    }
}

