/*
 * Decompiled with CFR 0.152.
 */
package com.ryderbelserion.fusion.paper.api.builders.gui.types;

import com.ryderbelserion.fusion.core.FusionProvider;
import com.ryderbelserion.fusion.core.api.FusionCore;
import com.ryderbelserion.fusion.core.api.exceptions.FusionException;
import com.ryderbelserion.fusion.paper.api.builders.gui.enums.InteractionComponent;
import com.ryderbelserion.fusion.paper.api.builders.gui.interfaces.GuiAction;
import com.ryderbelserion.fusion.paper.api.builders.gui.interfaces.GuiFiller;
import com.ryderbelserion.fusion.paper.api.builders.gui.interfaces.GuiItem;
import com.ryderbelserion.fusion.paper.api.builders.gui.interfaces.GuiType;
import com.ryderbelserion.fusion.paper.api.builders.gui.interfaces.types.IBaseGui;
import com.ryderbelserion.fusion.paper.api.enums.Scheduler;
import com.ryderbelserion.fusion.paper.api.scheduler.FoliaScheduler;
import com.ryderbelserion.fusion.paper.utils.ColorUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Server;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseGui
implements InventoryHolder,
Listener,
IBaseGui {
    private final FusionCore fusion = FusionProvider.get();
    private final JavaPlugin plugin;
    private final Server server;
    private final GuiFiller filler = new GuiFiller(this);
    private final Map<Integer, GuiAction<InventoryClickEvent>> slotActions;
    private final Map<Integer, GuiItem> guiItems;
    private final Set<InteractionComponent> interactionComponents;
    private GuiAction<InventoryClickEvent> defaultTopClickAction;
    private GuiAction<InventoryClickEvent> playerInventoryAction;
    private GuiAction<InventoryClickEvent> outsideClickAction;
    private GuiAction<InventoryClickEvent> defaultClickAction;
    private GuiAction<InventoryCloseEvent> closeGuiAction;
    private GuiAction<InventoryOpenEvent> openGuiAction;
    private GuiAction<InventoryDragEvent> dragAction;
    private GuiType guiType = GuiType.CHEST;
    private final Inventory inventory;
    private boolean isUpdating;
    private String title;
    private int rows;

    public BaseGui(@NotNull JavaPlugin plugin, @NotNull Audience audience, @NotNull String title, int rows, @NotNull Set<InteractionComponent> components) {
        this.plugin = plugin;
        this.server = this.plugin.getServer();
        this.title = title;
        this.rows = rows;
        int size = this.rows * 9;
        this.slotActions = new LinkedHashMap<Integer, GuiAction<InventoryClickEvent>>(size);
        this.guiItems = new LinkedHashMap<Integer, GuiItem>(size);
        this.interactionComponents = this.safeCopy(components);
        this.inventory = this.server.createInventory((InventoryHolder)this, size, this.title(audience));
    }

    public BaseGui(@NotNull JavaPlugin plugin, @NotNull String title, int rows, @NotNull Set<InteractionComponent> components) {
        this(plugin, Audience.empty(), title, rows, components);
    }

    public BaseGui(@NotNull JavaPlugin plugin, @NotNull Audience audience, @NotNull String title, @NotNull GuiType guiType, @NotNull Set<InteractionComponent> components) {
        this.plugin = plugin;
        this.server = this.plugin.getServer();
        this.title = title;
        this.slotActions = new LinkedHashMap<Integer, GuiAction<InventoryClickEvent>>(guiType.getLimit());
        this.guiItems = new LinkedHashMap<Integer, GuiItem>(guiType.getLimit());
        this.interactionComponents = this.safeCopy(components);
        this.inventory = this.server.createInventory((InventoryHolder)this, guiType.getInventoryType(), this.title(audience));
        this.guiType = guiType;
    }

    public BaseGui(@NotNull JavaPlugin plugin, @NotNull String title, @NotNull GuiType guiType, @NotNull Set<InteractionComponent> components) {
        this(plugin, Audience.empty(), title, guiType, components);
    }

    @Override
    @NotNull
    public final Map<Integer, GuiItem> getGuiItems() {
        return Collections.unmodifiableMap(this.guiItems);
    }

    @Override
    @NotNull
    public final String getTitle() {
        return PlainTextComponentSerializer.plainText().serialize(this.title());
    }

    @Override
    public void setTitle(@NotNull String title) {
        this.title = title;
    }

    @Override
    @NotNull
    public final Component title(@NotNull Audience audience) {
        return this.fusion.color(audience, this.title, new HashMap<String, String>());
    }

    @Override
    @NotNull
    public final Component title() {
        return this.title(Audience.empty());
    }

    @Override
    public final int getRows() {
        return this.rows;
    }

    @Override
    public void setRows(int rows) {
        this.rows = rows;
    }

    @Override
    public final int getSize() {
        return this.getRows() * 9;
    }

    @Override
    @NotNull
    public final GuiType getGuiType() {
        return this.guiType;
    }

    @Override
    @NotNull
    public final GuiFiller getFiller() {
        return this.filler;
    }

    @Override
    public void addInteractionComponent(InteractionComponent ... components) {
        this.interactionComponents.addAll(Arrays.asList(components));
    }

    @Override
    public void removeInteractionComponent(@NotNull InteractionComponent component) {
        this.interactionComponents.remove((Object)component);
    }

    @Override
    public final boolean canPerformOtherActions() {
        return !this.interactionComponents.contains((Object)InteractionComponent.PREVENT_OTHER_ACTIONS);
    }

    @Override
    public final boolean isInteractionsDisabled() {
        return this.interactionComponents.size() == InteractionComponent.VALUES.size();
    }

    @Override
    public final boolean canPlaceItems() {
        return !this.interactionComponents.contains((Object)InteractionComponent.PREVENT_ITEM_PLACE);
    }

    @Override
    public final boolean canTakeItems() {
        return !this.interactionComponents.contains((Object)InteractionComponent.PREVENT_ITEM_TAKE);
    }

    @Override
    public final boolean canSwapItems() {
        return !this.interactionComponents.contains((Object)InteractionComponent.PREVENT_ITEM_SWAP);
    }

    @Override
    public final boolean canDropItems() {
        return !this.interactionComponents.contains((Object)InteractionComponent.PREVENT_ITEM_DROP);
    }

    @Override
    public void giveItem(@NotNull Player player, @NotNull ItemStack itemStack) {
        player.getInventory().addItem(new ItemStack[]{itemStack});
    }

    @Override
    public void giveItem(@NotNull Player player, ItemStack ... itemStacks) {
        Arrays.asList(itemStacks).forEach(item -> this.giveItem(player, (ItemStack)item));
    }

    @Override
    public void setItem(int slot, @NotNull GuiItem guiItem) {
        this.validateSlot(slot);
        this.guiItems.put(slot, guiItem);
        this.inventory.setItem(slot, guiItem.getItemStack());
    }

    @Override
    public void setItem(int row, int col, @NotNull GuiItem guiItem) {
        this.setItem(this.getSlotFromRowColumn(row, col), guiItem);
    }

    @Override
    public void setItem(@NotNull List<Integer> slots, @NotNull GuiItem guiItem) {
        for (int slot : slots) {
            this.setItem(slot, guiItem);
        }
    }

    @Override
    public void addItem(GuiItem ... items) {
        this.addItem(false, items);
    }

    @Override
    public void addItem(boolean expandIfFull, GuiItem ... items) {
        ArrayList<GuiItem> notAddedItems = new ArrayList<GuiItem>();
        block0: for (GuiItem guiItem : items) {
            for (int slot = 0; slot < this.rows * 9; ++slot) {
                if (this.guiItems.get(slot) != null) {
                    if (slot != this.rows * 9 - 1) continue;
                    notAddedItems.add(guiItem);
                    continue;
                }
                this.guiItems.put(slot, guiItem);
                continue block0;
            }
        }
        if (!expandIfFull || this.rows >= 6 || notAddedItems.isEmpty() || this.guiType != null && this.guiType != GuiType.CHEST) {
            return;
        }
        ++this.rows;
        this.updateInventories();
        this.addItem(true, notAddedItems.toArray(new GuiItem[0]));
    }

    @Override
    public void removeItem(int row, int col) {
        this.removeItem(this.getSlotFromRowColumn(row, col));
    }

    @Override
    public void removeItem(int slot) {
        this.validateSlot(slot);
        this.guiItems.remove(slot);
    }

    @Override
    @Nullable
    public final GuiItem getGuiItem(int slot) {
        return this.guiItems.get(slot);
    }

    @Override
    public void addSlotAction(int slot, @Nullable GuiAction<@NotNull InventoryClickEvent> slotAction) {
        this.slotActions.put(slot, slotAction);
    }

    @Override
    @Nullable
    public final GuiAction<InventoryClickEvent> getSlotAction(int slot) {
        return this.slotActions.get(slot);
    }

    @Override
    public void close(final @NotNull Player player, final @NotNull InventoryCloseEvent.Reason reason, boolean isDelayed) {
        if (isDelayed) {
            new FoliaScheduler(this, this.plugin, Scheduler.global_scheduler){

                @Override
                public void run() {
                    player.closeInventory(reason);
                }
            }.runDelayed(2L);
            return;
        }
        player.closeInventory(reason);
    }

    @Override
    public void close(@NotNull Player player, boolean isDelayed) {
        this.close(player, InventoryCloseEvent.Reason.PLUGIN, isDelayed);
    }

    @Override
    public void close(@NotNull Player player) {
        this.close(player, true);
    }

    @Override
    public void updateTitle(@NotNull Player player, @NotNull Map<String, String> placeholders) {
        ColorUtils.updateTitle(player, this.title, placeholders);
    }

    @Override
    public void updateTitle(@NotNull Player player) {
        this.updateTitle(player, new HashMap<String, String>());
    }

    @Override
    public void updateInventory(@NotNull Player player) {
        this.inventory.clear();
        this.populate();
        player.updateInventory();
    }

    @Override
    public void updateTitles() {
        this.server.getOnlinePlayers().forEach(player -> {
            InventoryHolder inventory = player.getOpenInventory().getTopInventory().getHolder(false);
            if (!(inventory instanceof BaseGui)) {
                return;
            }
            this.updateTitle((Player)player);
        });
    }

    @Override
    public void updateInventories() {
        Inventory inventory = this.inventory;
        inventory.getViewers().forEach(humanEntity -> {
            if (humanEntity instanceof Player) {
                Player player = (Player)humanEntity;
                this.updateInventory(player);
            }
        });
    }

    @Override
    public final boolean isUpdating() {
        return this.isUpdating;
    }

    @Override
    public void setUpdating(boolean isUpdating) {
        this.isUpdating = isUpdating;
    }

    @Override
    @Nullable
    public final GuiAction<InventoryClickEvent> getDefaultClickAction() {
        return this.defaultClickAction;
    }

    @Override
    public void setDefaultClickAction(@Nullable GuiAction<@NotNull InventoryClickEvent> defaultClickAction) {
        this.defaultClickAction = defaultClickAction;
    }

    @Override
    @Nullable
    public final GuiAction<InventoryClickEvent> getDefaultTopClickAction() {
        return this.defaultTopClickAction;
    }

    @Override
    public void setDefaultTopClickAction(@Nullable GuiAction<@NotNull InventoryClickEvent> defaultTopClickAction) {
        this.defaultTopClickAction = defaultTopClickAction;
    }

    @Override
    @Nullable
    public final GuiAction<InventoryClickEvent> getPlayerInventoryAction() {
        return this.playerInventoryAction;
    }

    @Override
    public void setPlayerInventoryAction(@Nullable GuiAction<@NotNull InventoryClickEvent> playerInventoryAction) {
        this.playerInventoryAction = playerInventoryAction;
    }

    @Override
    @Nullable
    public final GuiAction<InventoryDragEvent> getDragAction() {
        return this.dragAction;
    }

    @Override
    public void setDragAction(@Nullable GuiAction<@NotNull InventoryDragEvent> dragAction) {
        this.dragAction = dragAction;
    }

    @Override
    @Nullable
    public final GuiAction<InventoryCloseEvent> getCloseGuiAction() {
        return this.closeGuiAction;
    }

    @Override
    public void setCloseGuiAction(@Nullable GuiAction<@NotNull InventoryCloseEvent> closeGuiAction) {
        this.closeGuiAction = closeGuiAction;
    }

    @Override
    @Nullable
    public final GuiAction<InventoryOpenEvent> getOpenGuiAction() {
        return this.openGuiAction;
    }

    @Override
    public void setOpenGuiAction(@Nullable GuiAction<@NotNull InventoryOpenEvent> openGuiAction) {
        this.openGuiAction = openGuiAction;
    }

    @Override
    @Nullable
    public final GuiAction<InventoryClickEvent> getOutsideClickAction() {
        return this.outsideClickAction;
    }

    @Override
    public void setOutsideClickAction(@Nullable GuiAction<@NotNull InventoryClickEvent> outsideClickAction) {
        this.outsideClickAction = outsideClickAction;
    }

    @Override
    public void open(@NotNull Player player, boolean purge) {
        if (player.isSleeping()) {
            return;
        }
        if (purge) {
            this.inventory.clear();
            this.populate();
        }
        player.openInventory(this.inventory);
    }

    @Override
    public void open(@NotNull Player player) {
        this.open(player, true);
    }

    @NotNull
    public final Inventory getInventory() {
        return this.inventory;
    }

    @NotNull
    public final GuiItem asGuiItem(@NotNull ItemStack itemStack) {
        return this.asGuiItem(itemStack, null);
    }

    @NotNull
    public final GuiItem asGuiItem(@NotNull ItemStack itemStack, @Nullable GuiAction<InventoryClickEvent> action) {
        return new GuiItem(itemStack, action);
    }

    public void populate() {
        for (Map.Entry<Integer, GuiItem> entry : this.guiItems.entrySet()) {
            this.inventory.setItem(entry.getKey().intValue(), entry.getValue().getItemStack());
        }
    }

    public final int getSlotFromRowColumn(int row, int col) {
        return col + (row - 1) * 9 - 1;
    }

    private void validateSlot(int slot) {
        int limit = this.guiType.getLimit();
        if (this.guiType == GuiType.CHEST) {
            if (slot < 0 || slot >= this.rows * limit) {
                this.throwInvalidSlot(slot);
            }
            return;
        }
        if (slot < 0 || slot > limit) {
            this.throwInvalidSlot(slot);
        }
    }

    private void throwInvalidSlot(int slot) {
        if (this.guiType == GuiType.CHEST) {
            throw new FusionException(String.format("Slot %s is not valid for the gui type %s and rows %s!", slot, this.guiType.name(), this.rows));
        }
        throw new FusionException(String.format("Slot %s is not valid for the gui type %s!", slot, this.guiType.name()));
    }
}

