/*
 * Decompiled with CFR 0.152.
 */
package com.ryderbelserion.map.config;

import com.ryderbelserion.fusion.core.FusionProvider;
import com.ryderbelserion.fusion.core.api.FusionCore;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Map;
import libs.org.simpleyaml.configuration.ConfigurationSection;
import net.pl3x.map.core.configuration.AbstractConfig;
import net.pl3x.map.core.markers.Point;
import net.pl3x.map.core.markers.Vector;
import net.pl3x.map.core.markers.option.Tooltip;
import net.pl3x.map.core.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BannerConfig
extends AbstractConfig {
    private static final FusionCore provider = FusionProvider.get();
    private static final Path path = provider.getPath();
    @AbstractConfig.Key(value="layer.label")
    @AbstractConfig.Comment(value="Label for map layer")
    public String LAYER_LABEL = "Banners";
    @AbstractConfig.Key(value="layer.show-controls")
    @AbstractConfig.Comment(value="Show controls for map layer")
    public boolean LAYER_SHOW_CONTROLS = true;
    @AbstractConfig.Key(value="layer.default-hidden")
    @AbstractConfig.Comment(value="Whether map layer is hidden by default")
    public boolean LAYER_DEFAULT_HIDDEN = false;
    @AbstractConfig.Key(value="layer.update-interval")
    @AbstractConfig.Comment(value="Update interval for map layer")
    public int LAYER_UPDATE_INTERVAL = 5;
    @AbstractConfig.Key(value="layer.priority")
    @AbstractConfig.Comment(value="Priority for map layer")
    public int LAYER_PRIORITY = 99;
    @AbstractConfig.Key(value="layer.z-index")
    @AbstractConfig.Comment(value="zIndex for map layer")
    public int LAYER_ZINDEX = 99;
    @AbstractConfig.Key(value="layer.css")
    @AbstractConfig.Comment(value="Custom CSS for the sign's layer.")
    public String LAYER_CSS = null;
    @AbstractConfig.Key(value="marker.icon.size")
    @AbstractConfig.Comment(value="The size (in pixels) the icon should be.")
    public Vector ICON_SIZE = new Vector(32.0, 32.0);
    @AbstractConfig.Key(value="marker.icon.anchor")
    @AbstractConfig.Comment(value="The coordinates of the \"tip\" of the icon (relative to its top\nleft corner). The icon will be aligned so that this point is at\nthe marker's geographical location. Centered by default if size\nis specified, also can be set in CSS with negative margins.")
    public Vector ICON_ANCHOR = null;
    @AbstractConfig.Key(value="marker.icon.rotation.angle")
    @AbstractConfig.Comment(value="The angle (in degrees) the icon should be rotated at. Rotation\nis in a clockwise direction with 0 being at the top.")
    public Double ICON_ROTATION_ANGLE = null;
    @AbstractConfig.Key(value="marker.icon.rotation.origin")
    @AbstractConfig.Comment(value="The origin point on the icon for the center of rotation")
    public String ICON_ROTATION_ORIGIN = null;
    @AbstractConfig.Key(value="marker.icon.shadow")
    @AbstractConfig.Comment(value="The registered icon to use for a shadow image.")
    public String ICON_SHADOW = null;
    @AbstractConfig.Key(value="marker.icon.shadow-size")
    @AbstractConfig.Comment(value="The size (in pixels) the icon's shadow image should be.")
    public Vector ICON_SHADOW_SIZE = new Vector(20.0, 20.0);
    @AbstractConfig.Key(value="marker.icon.shadow-anchor")
    @AbstractConfig.Comment(value="The coordinates of the \"tip\" of the shadow (relative to its\ntop left corner) (the same as icon anchor if not specified).")
    public Vector ICON_SHADOW_ANCHOR = null;
    @AbstractConfig.Key(value="marker.tooltip.content")
    @AbstractConfig.Comment(value="Contents of the icon's popup.")
    public String ICON_TOOLTIP_CONTENT = "<center><name></center>";
    @AbstractConfig.Key(value="marker.tooltip.pane")
    @AbstractConfig.Comment(value="Map pane where the tooltip will be added.")
    public String ICON_TOOLTIP_PANE = null;
    @AbstractConfig.Key(value="marker.tooltip.offset")
    @AbstractConfig.Comment(value="Optional offset of the tooltip position.")
    public Point ICON_TOOLTIP_OFFSET = new Point(0, -6);
    @AbstractConfig.Key(value="marker.tooltip.direction")
    @AbstractConfig.Comment(value="Direction where to open the tooltip. Possible values are: right,\nleft, top, bottom, center, auto. auto will dynamically switch\nbetween right and left according to the tooltip position\non the map.")
    public Tooltip.Direction ICON_TOOLTIP_DIRECTION = Tooltip.Direction.TOP;
    @AbstractConfig.Key(value="marker.tooltip.permanent")
    @AbstractConfig.Comment(value="Whether to open the tooltip permanently or only on mouseover.")
    public Boolean ICON_TOOLTIP_PERMANENT = null;
    @AbstractConfig.Key(value="marker.tooltip.sticky")
    @AbstractConfig.Comment(value="If true, the tooltip will follow the mouse instead of being\nfixed at the feature center.")
    public Boolean ICON_TOOLTIP_STICKY = null;
    @AbstractConfig.Key(value="marker.tooltip.opacity")
    @AbstractConfig.Comment(value="Tooltip container opacity.")
    public Double ICON_TOOLTIP_OPACITY = null;
    @AbstractConfig.Key(value="marker.popup.content")
    @AbstractConfig.Comment(value="Contents of the icon's popup.")
    public String ICON_POPUP_CONTENT = null;
    @AbstractConfig.Key(value="marker.popup.pane")
    @AbstractConfig.Comment(value="Map pane where the popup will be added.")
    public String ICON_POPUP_PANE = null;
    @AbstractConfig.Key(value="marker.popup.offset")
    @AbstractConfig.Comment(value="The offset of the popup position.")
    public Point ICON_POPUP_OFFSET = null;
    @AbstractConfig.Key(value="marker.popup.max-width")
    @AbstractConfig.Comment(value="Max width of the popup, in pixels.")
    public Integer ICON_POPUP_MAX_WIDTH = null;
    @AbstractConfig.Key(value="marker.popup.min-width")
    @AbstractConfig.Comment(value="Min width of the popup, in pixels.")
    public Integer ICON_POPUP_MIN_WIDTH = null;
    @AbstractConfig.Key(value="marker.popup.max-height")
    @AbstractConfig.Comment(value="If set, creates a scrollable container of the given height inside\na popup if its content exceeds it. The scrollable container can\nbe styled using the leaflet-popup-scrolled CSS class selector.")
    public Integer ICON_POPUP_MAX_HEIGHT = null;
    @AbstractConfig.Key(value="marker.popup.auto-pan.enabled")
    @AbstractConfig.Comment(value="Set it to false if you don't want the map to do panning animation\nto fit the opened popup.")
    public Boolean ICON_POPUP_SHOULD_AUTO_PAN = null;
    @AbstractConfig.Key(value="marker.popup.auto-pan.padding.all")
    @AbstractConfig.Comment(value="Equivalent of setting both top left and bottom right auto-pan\npadding to the same value.")
    public Point ICON_POPUP_AUTO_PAN_PADDING_TOP_LEFT = null;
    @AbstractConfig.Key(value="marker.popup.auto-pan.padding.top-left")
    @AbstractConfig.Comment(value="The margin between the popup and the top left corner of the\nmap view after auto-panning was performed.")
    public Point ICON_POPUP_AUTO_PAN_PADDING_BOTTOM_RIGHT = null;
    @AbstractConfig.Key(value="marker.popup.auto-pan.padding.bottom-right")
    @AbstractConfig.Comment(value="The margin between the popup and the bottom right corner of\nthe map view after auto-panning was performed.")
    public Point ICON_POPUP_AUTO_PAN_PADDING = null;
    @AbstractConfig.Key(value="marker.popup.should-keep-in-view")
    @AbstractConfig.Comment(value="Set it to true if you want to prevent users from panning\nthe popup off of the screen while it is open.")
    public Boolean ICON_POPUP_SHOULD_KEEP_IN_VIEW = null;
    @AbstractConfig.Key(value="marker.popup.show-close-button")
    @AbstractConfig.Comment(value="Controls the presence of a close button in the popup.")
    public Boolean ICON_POPUP_CLOSE_BUTTON = null;
    @AbstractConfig.Key(value="marker.popup.should-auto-close")
    @AbstractConfig.Comment(value="Set it to false if you want to override the default behavior\nof the popup closing when another popup is opened.")
    public Boolean ICON_POPUP_SHOULD_AUTO_CLOSE = null;
    @AbstractConfig.Key(value="marker.popup.should-close-on-escape-key")
    @AbstractConfig.Comment(value="Set it to false if you want to override the default behavior\nof the ESC key for closing of the popup.")
    public Boolean ICON_POPUP_SHOULD_CLOSE_ON_ESCAPE_KEY = null;
    @AbstractConfig.Key(value="marker.popup.should-close-on-click")
    @AbstractConfig.Comment(value="Set it if you want to override the default behavior of the\npopup closing when user clicks on the map. Defaults to true.")
    public Boolean ICON_POPUP_SHOULD_CLOSE_ON_CLICK = null;
    @AbstractConfig.Key(value="root.banners.block-place")
    @AbstractConfig.Comment(value="Should banners be displayed on block place?")
    public static boolean banners_block_place = true;
    @AbstractConfig.Key(value="banner.add.particles")
    @AbstractConfig.Comment(value="The particles to play when a banner is added to Pl3xMap.\nhttps://minecraft.wiki/w/Particles_(Java_Edition)")
    public String BANNER_ADD_PARTICLES = "happy_villager";
    @AbstractConfig.Key(value="banner.add.sound")
    @AbstractConfig.Comment(value="The sound to play when a banner is added to Pl3xMap.\nhttps://minecraft.wiki/w/Sounds.json#Java_Edition_values")
    public String BANNER_ADD_SOUND = "entity.player.levelup";
    @AbstractConfig.Key(value="banner.remove.particles")
    @AbstractConfig.Comment(value="The particles to play when a banner is removed from Pl3xMap.\nhttps://minecraft.wiki/w/Particles_(Java_Edition)")
    public String BANNER_REMOVE_PARTICLES = "wax_on";
    @AbstractConfig.Key(value="banner.remove.sound")
    @AbstractConfig.Comment(value="The sound to play when a banner is removed from Pl3xMap.\nhttps://minecraft.wiki/w/Sounds.json#Java_Edition_values")
    public String BANNER_REMOVE_SOUND = "entity.ghast.hurt";
    private final World world;

    public BannerConfig(@NotNull World world) {
        this.world = world;
        this.reload();
    }

    @NotNull
    public World getWorld() {
        return this.world;
    }

    public void reload() {
        this.reload(path.resolve("banners").resolve("config.yml"), BannerConfig.class);
    }

    @NotNull
    protected Object getClassObject() {
        return this;
    }

    @Nullable
    protected Object getValue(@NotNull String path, @Nullable Object def) {
        if (this.getConfig().get("world-settings.default." + path) == null) {
            this.set("world-settings.default." + path, def);
        }
        return this.get("world-settings." + this.world.getName() + "." + path, this.get("world-settings.default." + path, def));
    }

    protected void setComment(@NotNull String path, @Nullable String comment) {
        this.getConfig().setComment("world-settings.default." + path, comment);
    }

    @Nullable
    protected Object get(@NotNull String path) {
        Object value = this.getConfig().get(path);
        if (value == null) {
            return null;
        }
        switch (path.substring(path.indexOf(".", path.indexOf(".") + 1) + 1)) {
            case "marker.icon.size": 
            case "marker.icon.anchor": 
            case "marker.icon.shadow-size": 
            case "marker.icon.shadow-anchor": {
                if (value instanceof ConfigurationSection) {
                    ConfigurationSection section = (ConfigurationSection)value;
                    return Vector.of((double)section.getDouble("x"), (double)section.getDouble("z"));
                }
                if (!(value instanceof Map)) break;
                Map vector = (Map)value;
                return Vector.of((double)((Double)vector.get("x")), (double)((Double)vector.get("z")));
            }
            case "marker.tooltip.offset": 
            case "marker.popup.offset": 
            case "marker.popup.auto-pan.padding.all": 
            case "marker.popup.auto-pan.padding.top-left": 
            case "marker.popup.auto-pan.padding.bottom-right": {
                if (value instanceof ConfigurationSection) {
                    ConfigurationSection section = (ConfigurationSection)value;
                    return Point.of((int)section.getInt("x"), (int)section.getInt("z"));
                }
                if (!(value instanceof Map)) break;
                Map point = (Map)value;
                return Point.of((int)((Integer)point.get("x")), (int)((Integer)point.get("z")));
            }
            case "marker.tooltip.direction": {
                return Tooltip.Direction.valueOf((String)String.valueOf(value).toUpperCase(Locale.ROOT));
            }
        }
        return super.get(path);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void set(@NotNull String path, @Nullable Object value) {
        if (value instanceof Point) {
            int z;
            int x;
            Point point = (Point)value;
            try {
                int n;
                x = n = point.x();
                z = n = point.z();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            value = Map.of("x", x, "z", z);
        } else if (value instanceof Vector) {
            double z;
            double x;
            Vector vector = (Vector)value;
            {
                double d;
                x = d = vector.x();
                z = d = vector.z();
            }
            value = Map.of("x", x, "z", z);
        } else if (value instanceof Tooltip.Direction) {
            Tooltip.Direction direction = (Tooltip.Direction)value;
            value = direction.name();
        }
        this.getConfig().set(path, value);
    }
}

