/*
 * Decompiled with CFR 0.152.
 */
package com.ryderbelserion.map.config;

import com.ryderbelserion.fusion.core.FusionProvider;
import com.ryderbelserion.fusion.core.api.FusionCore;
import java.nio.file.Path;
import java.util.Map;
import libs.org.simpleyaml.configuration.ConfigurationSection;
import net.pl3x.map.core.configuration.AbstractConfig;
import net.pl3x.map.core.markers.Vector;
import net.pl3x.map.core.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MobConfig
extends AbstractConfig {
    private static final FusionCore provider = FusionProvider.get();
    private static final Path path = provider.getPath();
    @AbstractConfig.Key(value="layer.label")
    @AbstractConfig.Comment(value="Label for map layer")
    public String LAYER_LABEL = "Mobs";
    @AbstractConfig.Key(value="layer.show-controls")
    @AbstractConfig.Comment(value="Show controls for map layer")
    public boolean LAYER_SHOW_CONTROLS = true;
    @AbstractConfig.Key(value="layer.default-hidden")
    @AbstractConfig.Comment(value="Whether map layer is hidden by default")
    public boolean LAYER_DEFAULT_HIDDEN = false;
    @AbstractConfig.Key(value="layer.update-interval")
    @AbstractConfig.Comment(value="Update interval for map layer")
    public int LAYER_UPDATE_INTERVAL = 1;
    @AbstractConfig.Key(value="layer.priority")
    @AbstractConfig.Comment(value="Priority for map layer")
    public int LAYER_PRIORITY = 99;
    @AbstractConfig.Key(value="layer.z-index")
    @AbstractConfig.Comment(value="zIndex for map layer")
    public int LAYER_ZINDEX = 1;
    @AbstractConfig.Key(value="marker.icon.size")
    @AbstractConfig.Comment(value="The size (in pixels) the icon should be.")
    public Vector ICON_SIZE = new Vector(20.0, 20.0);
    @AbstractConfig.Key(value="marker.popup.content")
    @AbstractConfig.Comment(value="Contents of the icon's popup.")
    public String ICON_TOOLTIP_CONTENT = "<mob-id>";
    @AbstractConfig.Key(value="only-show-mobs-exposed-to-sky")
    @AbstractConfig.Comment(value="Only show mobs that are exposed to the sky.")
    public boolean ONLY_SHOW_MOBS_EXPOSED_TO_SKY = true;
    private final World world;

    public MobConfig(@NotNull World world) {
        this.world = world;
        this.reload();
    }

    @NotNull
    public World getWorld() {
        return this.world;
    }

    public void reload() {
        this.reload(path.resolve("mobs").resolve("config.yml"), MobConfig.class);
    }

    @NotNull
    protected Object getClassObject() {
        return this;
    }

    @Nullable
    protected Object getValue(@NotNull String path, @Nullable Object def) {
        if (this.getConfig().get("world-settings.default." + path) == null) {
            this.set("world-settings.default." + path, def);
        }
        return this.get("world-settings." + this.world.getName() + "." + path, this.get("world-settings.default." + path, def));
    }

    protected void setComment(@NotNull String path, @Nullable String comment) {
        this.getConfig().setComment("world-settings.default." + path, comment);
    }

    @Nullable
    protected Object get(@NotNull String path) {
        Object value = this.getConfig().get(path);
        if (value == null) {
            return null;
        }
        if ("marker.icon.size".equals(path.substring(path.indexOf(".", path.indexOf(".") + 1) + 1))) {
            if (value instanceof ConfigurationSection) {
                ConfigurationSection section = (ConfigurationSection)value;
                return Vector.of((double)section.getDouble("x"), (double)section.getDouble("z"));
            }
            if (value instanceof Map) {
                Map map = (Map)value;
                return Vector.of((double)((Double)map.get("x")), (double)((Double)map.get("z")));
            }
        }
        return super.get(path);
    }

    protected void set(@NotNull String path, @Nullable Object value) {
        if (value instanceof Vector) {
            double x;
            double d;
            Vector vector = (Vector)value;
            try {
                x = d = vector.x();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            double z = d = vector.z();
            value = Map.of("x", x, "z", z);
        }
        this.getConfig().set(path, (Object)value);
    }
}

