/*
 * Decompiled with CFR 0.152.
 */
package com.ryderbelserion.map.config;

import com.ryderbelserion.fusion.core.FusionProvider;
import com.ryderbelserion.fusion.core.api.FusionCore;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Map;
import libs.org.simpleyaml.configuration.ConfigurationSection;
import net.pl3x.map.core.configuration.AbstractConfig;
import net.pl3x.map.core.markers.Vector;
import net.pl3x.map.core.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SignsConfig
extends AbstractConfig {
    private static final FusionCore provider = FusionProvider.get();
    private static final Path path = provider.getPath();
    @AbstractConfig.Key(value="layer.label")
    @AbstractConfig.Comment(value="Label for map layer")
    public String LAYER_LABEL = "Signs";
    @AbstractConfig.Key(value="layer.show-controls")
    @AbstractConfig.Comment(value="Show controls for map layer")
    public boolean LAYER_SHOW_CONTROLS = true;
    @AbstractConfig.Key(value="layer.default-hidden")
    @AbstractConfig.Comment(value="Whether map layer is hidden by default")
    public boolean LAYER_DEFAULT_HIDDEN = false;
    @AbstractConfig.Key(value="layer.update-interval")
    @AbstractConfig.Comment(value="Update interval for map layer")
    public int LAYER_UPDATE_INTERVAL = 5;
    @AbstractConfig.Key(value="layer.priority")
    @AbstractConfig.Comment(value="Priority for map layer")
    public int LAYER_PRIORITY = 99;
    @AbstractConfig.Key(value="layer.z-index")
    @AbstractConfig.Comment(value="zIndex for map layer")
    public int LAYER_ZINDEX = 99;
    @AbstractConfig.Key(value="layer.css")
    @AbstractConfig.Comment(value="Custom CSS for the sign's layer.")
    public String LAYER_CSS = "@import url('https://fonts.cdnfonts.com/css/minecraftia');\ndiv.leaflet-pl3xmap_acacia_sign_popup-pane,\ndiv.leaflet-pl3xmap_bamboo_sign_popup-pane,\ndiv.leaflet-pl3xmap_birch_sign_popup-pane,\ndiv.leaflet-pl3xmap_cherry_sign_popup-pane,\ndiv.leaflet-pl3xmap_crimson_sign_popup-pane,\ndiv.leaflet-pl3xmap_dark_oak_sign_popup-pane,\ndiv.leaflet-pl3xmap_jungle_sign_popup-pane,\ndiv.leaflet-pl3xmap_mangrove_sign_popup-pane,\ndiv.leaflet-pl3xmap_oak_sign_popup-pane,\ndiv.leaflet-pl3xmap_spruce_sign_popup-pane,\ndiv.leaflet-pl3xmap_warped_sign_popup-pane {\n  z-index:999;\n  pointer-events: none;\n}\ndiv.leaflet-pl3xmap_acacia_sign_popup-pane .leaflet-popup-content-wrapper::before,\ndiv.leaflet-pl3xmap_bamboo_sign_popup-pane .leaflet-popup-content-wrapper::before,\ndiv.leaflet-pl3xmap_birch_sign_popup-pane .leaflet-popup-content-wrapper::before,\ndiv.leaflet-pl3xmap_cherry_sign_popup-pane .leaflet-popup-content-wrapper::before,\ndiv.leaflet-pl3xmap_crimson_sign_popup-pane .leaflet-popup-content-wrapper::before,\ndiv.leaflet-pl3xmap_dark_oak_sign_popup-pane .leaflet-popup-content-wrapper::before,\ndiv.leaflet-pl3xmap_jungle_sign_popup-pane .leaflet-popup-content-wrapper::before,\ndiv.leaflet-pl3xmap_mangrove_sign_popup-pane .leaflet-popup-content-wrapper::before,\ndiv.leaflet-pl3xmap_oak_sign_popup-pane .leaflet-popup-content-wrapper::before,\ndiv.leaflet-pl3xmap_spruce_sign_popup-pane .leaflet-popup-content-wrapper::before,\ndiv.leaflet-pl3xmap_warped_sign_popup-pane .leaflet-popup-content-wrapper::before {\n  content: \"\";\n  position: absolute;\n  top: -500vh;\n  left: -500vw;\n  width: 1000vw;\n  height: 1000vh;\n  backdrop-filter: blur(2px);\n  background-color: rgba(0,0,0,0.5);\n  z-index: -1;\n}\ndiv.leaflet-pl3xmap_acacia_sign_popup-pane div.leaflet-popup-content-wrapper {\n  background-image: url('images/icon/registered/pl3xmap_acacia_sign_tooltip.png') !important;\n}\ndiv.leaflet-pl3xmap_bamboo_sign_popup-pane div.leaflet-popup-content-wrapper {\n  background-image: url('images/icon/registered/pl3xmap_bamboo_sign_tooltip.png') !important;\n}\ndiv.leaflet-pl3xmap_birch_sign_popup-pane div.leaflet-popup-content-wrapper {\n  background-image: url('images/icon/registered/pl3xmap_birch_sign_tooltip.png') !important;\n}\ndiv.leaflet-pl3xmap_cherry_sign_popup-pane div.leaflet-popup-content-wrapper {\n  background-image: url('images/icon/registered/pl3xmap_cherry_sign_tooltip.png') !important;\n}\ndiv.leaflet-pl3xmap_crimson_sign_popup-pane div.leaflet-popup-content-wrapper {\n  background-image: url('images/icon/registered/pl3xmap_crimson_sign_tooltip.png') !important;\n}\ndiv.leaflet-pl3xmap_dark_oak_sign_popup-pane div.leaflet-popup-content-wrapper {\n  background-image: url('images/icon/registered/pl3xmap_dark_oak_sign_tooltip.png') !important;\n}\ndiv.leaflet-pl3xmap_jungle_sign_popup-pane div.leaflet-popup-content-wrapper {\n  background-image: url('images/icon/registered/pl3xmap_jungle_sign_tooltip.png') !important;\n}\ndiv.leaflet-pl3xmap_mangrove_sign_popup-pane div.leaflet-popup-content-wrapper {\n  background-image: url('images/icon/registered/pl3xmap_mangrove_sign_tooltip.png') !important;\n}\ndiv.leaflet-pl3xmap_oak_sign_popup-pane div.leaflet-popup-content-wrapper {\n  background-image: url('images/icon/registered/pl3xmap_oak_sign_tooltip.png') !important;\n}\ndiv.leaflet-pl3xmap_spruce_sign_popup-pane div.leaflet-popup-content-wrapper {\n  background-image: url('images/icon/registered/pl3xmap_spruce_sign_tooltip.png') !important;\n}\ndiv.leaflet-pl3xmap_warped_sign_popup-pane div.leaflet-popup-content-wrapper {\n  background-image: url('images/icon/registered/pl3xmap_warped_sign_tooltip.png') !important;\n}\ndiv.leaflet-pl3xmap_acacia_sign_popup-pane div.leaflet-popup-content-wrapper,\ndiv.leaflet-pl3xmap_bamboo_sign_popup-pane div.leaflet-popup-content-wrapper,\ndiv.leaflet-pl3xmap_birch_sign_popup-pane div.leaflet-popup-content-wrapper,\ndiv.leaflet-pl3xmap_cherry_sign_popup-pane div.leaflet-popup-content-wrapper,\ndiv.leaflet-pl3xmap_crimson_sign_popup-pane div.leaflet-popup-content-wrapper,\ndiv.leaflet-pl3xmap_dark_oak_sign_popup-pane div.leaflet-popup-content-wrapper,\ndiv.leaflet-pl3xmap_jungle_sign_popup-pane div.leaflet-popup-content-wrapper,\ndiv.leaflet-pl3xmap_mangrove_sign_popup-pane div.leaflet-popup-content-wrapper,\ndiv.leaflet-pl3xmap_oak_sign_popup-pane div.leaflet-popup-content-wrapper,\ndiv.leaflet-pl3xmap_spruce_sign_popup-pane div.leaflet-popup-content-wrapper,\ndiv.leaflet-pl3xmap_warped_sign_popup-pane div.leaflet-popup-content-wrapper {\n  margin: 0;\n  padding: 0;\n  border: 0;\n  width: 196px !important;\n  min-width: 196px;\n  max-width: 196px;\n  height: 210px !important;\n  min-height: 210px;\n  max-height: 210px;\n  background: transparent;\n  background-repeat: no-repeat;\n  box-shadow: none;\n}\ndiv.leaflet-pl3xmap_acacia_sign_popup-pane div.leaflet-popup-content,\ndiv.leaflet-pl3xmap_bamboo_sign_popup-pane div.leaflet-popup-content,\ndiv.leaflet-pl3xmap_birch_sign_popup-pane div.leaflet-popup-content,\ndiv.leaflet-pl3xmap_cherry_sign_popup-pane div.leaflet-popup-content,\ndiv.leaflet-pl3xmap_crimson_sign_popup-pane div.leaflet-popup-content,\ndiv.leaflet-pl3xmap_dark_oak_sign_popup-pane div.leaflet-popup-content,\ndiv.leaflet-pl3xmap_jungle_sign_popup-pane div.leaflet-popup-content,\ndiv.leaflet-pl3xmap_mangrove_sign_popup-pane div.leaflet-popup-content,\ndiv.leaflet-pl3xmap_oak_sign_popup-pane div.leaflet-popup-content,\ndiv.leaflet-pl3xmap_spruce_sign_popup-pane div.leaflet-popup-content,\ndiv.leaflet-pl3xmap_warped_sign_popup-pane div.leaflet-popup-content {\n  overflow: hidden !important;\n  margin: 0;\n  padding: 16px 14px 14px 14px !important;\n  border: 0;\n  width: 196px !important;\n  min-width: 196px;\n  max-width: 196px;\n  height: 210px !important;\n  min-height: 210px;\n  max-height: 210px;\n  font-family: 'Minecraftia', sans-serif;\n  font-weight: 700;\n  font-size:13px;\n  line-height: 1.5;\n  color: #000000;\n}\ndiv.leaflet-pl3xmap_acacia_sign_popup-pane div.leaflet-popup-tip-container,\ndiv.leaflet-pl3xmap_bamboo_sign_popup-pane div.leaflet-popup-tip-container,\ndiv.leaflet-pl3xmap_birch_sign_popup-pane div.leaflet-popup-tip-container,\ndiv.leaflet-pl3xmap_cherry_sign_popup-pane div.leaflet-popup-tip-container,\ndiv.leaflet-pl3xmap_crimson_sign_popup-pane div.leaflet-popup-tip-container,\ndiv.leaflet-pl3xmap_dark_oak_sign_popup-pane div.leaflet-popup-tip-container,\ndiv.leaflet-pl3xmap_jungle_sign_popup-pane div.leaflet-popup-tip-container,\ndiv.leaflet-pl3xmap_mangrove_sign_popup-pane div.leaflet-popup-tip-container,\ndiv.leaflet-pl3xmap_oak_sign_popup-pane div.leaflet-popup-tip-container,\ndiv.leaflet-pl3xmap_spruce_sign_popup-pane div.leaflet-popup-tip-container,\ndiv.leaflet-pl3xmap_warped_sign_popup-pane div.leaflet-popup-tip-container {\n  display: none;\n}\ndiv.leaflet-pl3xmap_acacia_sign_popup-pane div,\ndiv.leaflet-pl3xmap_bamboo_sign_popup-pane div,\ndiv.leaflet-pl3xmap_birch_sign_popup-pane div,\ndiv.leaflet-pl3xmap_cherry_sign_popup-pane div,\ndiv.leaflet-pl3xmap_crimson_sign_popup-pane div,\ndiv.leaflet-pl3xmap_dark_oak_sign_popup-pane div,\ndiv.leaflet-pl3xmap_jungle_sign_popup-pane div,\ndiv.leaflet-pl3xmap_mangrove_sign_popup-pane div,\ndiv.leaflet-pl3xmap_oak_sign_popup-pane div,\ndiv.leaflet-pl3xmap_spruce_sign_popup-pane div,\ndiv.leaflet-pl3xmap_warped_sign_popup-pane div {\n  transition: all 0.25s;\n}\ncenter.pl3xmap_signs_popup {\n  pointer-events: auto;\n  min-width: 168px;\n  min-height: 80px;\n}";
    @AbstractConfig.Key(value="marker.icon.size")
    @AbstractConfig.Comment(value="The size (in pixels) the icon should be.")
    public Vector ICON_SIZE = new Vector(20.0, 20.0);
    @AbstractConfig.Key(value="marker.popup.content")
    @AbstractConfig.Comment(value="Contents of the icon's popup.")
    public String ICON_POPUP_CONTENT = "<center class=\"pl3xmap_signs_popup\">\n  <line1><br/>\n  <line2><br/>\n  <line3><br/>\n  <line4>\n</center>";
    @AbstractConfig.Key(value="sign.add.particles")
    @AbstractConfig.Comment(value="The particles to play when a sign is added to Pl3xMap.\nhttps://minecraft.wiki/w/Particles_(Java_Edition)")
    public String SIGN_ADD_PARTICLES = "happy_villager";
    @AbstractConfig.Key(value="sign.add.sound")
    @AbstractConfig.Comment(value="The sound to play when a sign is added to Pl3xMap.\nhttps://minecraft.wiki/w/Sounds.json#Java_Edition_values")
    public String SIGN_ADD_SOUND = "entity.player.levelup";
    @AbstractConfig.Key(value="sign.remove.particles")
    @AbstractConfig.Comment(value="The particles to play when a sign is removed from Pl3xMap.\nhttps://minecraft.wiki/w/Particles_(Java_Edition)")
    public String SIGN_REMOVE_PARTICLES = "wax_on";
    @AbstractConfig.Key(value="sign.remove.sound")
    @AbstractConfig.Comment(value="The sound to play when a sign is removed from Pl3xMap.\nhttps://minecraft.wiki/w/Sounds.json#Java_Edition_values")
    public String SIGN_REMOVE_SOUND = "entity.ghast.hurt";
    @AbstractConfig.Key(value="sign.block-place")
    @AbstractConfig.Comment(value="Should signs be displayed on block place?")
    public boolean SIGN_BLOCK_PLACE = true;
    private final World world;

    public SignsConfig(@NotNull World world) {
        this.world = world;
        this.reload();
    }

    @NotNull
    public World getWorld() {
        return this.world;
    }

    public void reload() {
        this.reload(path.resolve("signs").resolve("config.yml"), SignsConfig.class);
    }

    @NotNull
    protected Object getClassObject() {
        return this;
    }

    @Nullable
    protected Object getValue(@NotNull String path, @Nullable Object def) {
        if (this.getConfig().get("world-settings.default." + path) == null) {
            this.set("world-settings.default." + path, def);
        }
        return this.get("world-settings." + this.world.getName() + "." + path, this.get("world-settings.default." + path, def));
    }

    protected void setComment(@NotNull String path, @Nullable String comment) {
        this.getConfig().setComment("world-settings.default." + path, comment);
    }

    @Nullable
    protected Object get(@NotNull String path) {
        String subpath;
        Object value = this.getConfig().get(path);
        if (value == null) {
            return null;
        }
        switch (subpath = path.substring(path.indexOf(".", path.indexOf(".") + 1) + 1)) {
            case "marker.icon.size": {
                if (value instanceof ConfigurationSection) {
                    ConfigurationSection section = (ConfigurationSection)value;
                    return Vector.of((double)section.getDouble("x"), (double)section.getDouble("z"));
                }
                if (!(value instanceof Map)) break;
                Map map = (Map)value;
                return Vector.of((double)((Double)map.get("x")), (double)((Double)map.get("z")));
            }
            case "sign.add.particles": 
            case "sign.remove.particles": 
            case "sign.add.sound": 
            case "sign.remove.sound": {
                try {
                    return value.toString().toUpperCase(Locale.ROOT);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    return null;
                }
            }
        }
        return super.get(path);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void set(@NotNull String path, @Nullable Object value) {
        if (value instanceof Vector) {
            double z;
            double x;
            Vector vector = (Vector)value;
            try {
                double d;
                x = d = vector.x();
                z = d = vector.z();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            value = Map.of("x", x, "z", z);
        } else if (value instanceof Enum) {
            Enum enumeration = (Enum)((Object)value);
            value = enumeration.name();
        }
        this.getConfig().set(path, value);
    }
}

