/*
 * Decompiled with CFR 0.152.
 */
package com.ryderbelserion.map.hook;

import com.ryderbelserion.map.hook.claims.claimchunk.ClaimChunkHook;
import com.ryderbelserion.map.hook.claims.griefdefender.GriefDefenderHook;
import com.ryderbelserion.map.hook.claims.griefprevention.GriefPreventionHook;
import com.ryderbelserion.map.hook.claims.plotsquared.P2Hook;
import com.ryderbelserion.map.hook.claims.worldguard.WorldGuardHook;
import com.ryderbelserion.map.hook.warps.essentials.EssentialsHook;
import com.ryderbelserion.map.hook.warps.playerwarps.PlayerWarpsHook;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.pl3x.map.core.markers.marker.Marker;
import net.pl3x.map.core.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Hook {
    public static final Collection<Marker<?>> EMPTY_LIST = new ArrayList();
    public static final Map<String, Hook> HOOKS = new HashMap<String, Hook>();

    @NotNull
    public static Collection<Hook> hooks() {
        return HOOKS.values();
    }

    public static void add(@NotNull String name) {
        Hook.add(Impl.get(name));
    }

    public static void add(@Nullable Impl impl) {
        if (impl != null) {
            HOOKS.put(impl.name, impl.hook.get());
        }
    }

    public static void remove(@NotNull String name) {
        HOOKS.remove(name);
    }

    public static void clear() {
        HOOKS.clear();
    }

    public void registerWorld(@NotNull World var1);

    public void unloadWorld(@NotNull World var1);

    @NotNull
    public Collection<Marker<?>> getData(@NotNull World var1);

    public static enum Impl {
        ESSENTIALS("Essentials", EssentialsHook::new),
        PLAYERWARPS("PlayerWarps", PlayerWarpsHook::new),
        CLAIMCHUNK("ClaimChunk", ClaimChunkHook::new),
        GRIEFDEFENDER("GriefDefender", GriefDefenderHook::new),
        GRIEFPREVENTION("GriefPrevention", GriefPreventionHook::new),
        PLOTSQUARED("PlotSquared", P2Hook::new),
        WORLDGUARD("WorldGuard", WorldGuardHook::new);

        private final String name;
        private final Supplier<Hook> hook;
        @NotNull
        static final Map<String, Impl> MAP;

        private Impl(String name, Supplier<Hook> hook) {
            this.name = name;
            this.hook = hook;
        }

        @NotNull
        public final String getPluginName() {
            return this.name;
        }

        @Nullable
        static Impl get(@NotNull String name) {
            return MAP.get(name);
        }

        static {
            MAP = new HashMap<String, Impl>();
            for (Impl impl : Impl.values()) {
                MAP.put(impl.name, impl);
            }
        }
    }
}

