/*
 * Decompiled with CFR 0.152.
 */
package com.ryderbelserion.map.hook.claims.claimchunk;

import com.ryderbelserion.map.hook.claims.claimchunk.ClaimChunkClaim;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public class ClaimChunkGroup {
    private final List<ClaimChunkClaim> claims = new ArrayList<ClaimChunkClaim>();
    private final UUID owner;

    public ClaimChunkGroup(@NotNull ClaimChunkClaim claim, @NotNull UUID owner) {
        this.add(claim);
        this.owner = owner;
    }

    public boolean isTouching(@NotNull ClaimChunkClaim claim) {
        for (ClaimChunkClaim toChk : this.claims) {
            if (!toChk.isTouching(claim)) continue;
            return true;
        }
        return false;
    }

    public boolean isTouching(@NotNull ClaimChunkGroup group) {
        for (ClaimChunkClaim claim : group.claims()) {
            if (!this.isTouching(claim)) continue;
            return true;
        }
        return false;
    }

    public void add(@NotNull ClaimChunkClaim claim) {
        this.claims.add(claim);
    }

    public void add(@NotNull ClaimChunkGroup group) {
        this.claims.addAll(group.claims());
    }

    @NotNull
    public List<ClaimChunkClaim> claims() {
        return this.claims;
    }

    @NotNull
    public UUID owner() {
        return this.owner;
    }

    @NotNull
    public String id() {
        if (!this.claims.isEmpty()) {
            ClaimChunkClaim claim = this.claims.getFirst();
            return claim.minX() + "_" + claim.minZ();
        }
        return "NaN_NaN";
    }
}

