/*
 * Decompiled with CFR 0.152.
 */
package com.ryderbelserion.map.hook.claims.claimchunk;

import com.cjburkey.claimchunk.ClaimChunk;
import com.cjburkey.claimchunk.chunk.DataChunk;
import com.cjburkey.claimchunk.data.newdata.IClaimChunkDataHandler;
import com.ryderbelserion.map.hook.Hook;
import com.ryderbelserion.map.hook.claims.claimchunk.ClaimChunkClaim;
import com.ryderbelserion.map.hook.claims.claimchunk.ClaimChunkConfig;
import com.ryderbelserion.map.hook.claims.claimchunk.ClaimChunkGroup;
import com.ryderbelserion.map.hook.claims.claimchunk.ClaimChunkLayer;
import com.ryderbelserion.map.util.ChunkUtil;
import com.ryderbelserion.map.util.ConfigUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.pl3x.map.core.Keyed;
import net.pl3x.map.core.markers.Point;
import net.pl3x.map.core.markers.marker.Marker;
import net.pl3x.map.core.markers.marker.Rectangle;
import net.pl3x.map.core.markers.option.Fill;
import net.pl3x.map.core.markers.option.Options;
import net.pl3x.map.core.util.Colors;
import net.pl3x.map.core.world.World;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Listener;
import org.jetbrains.annotations.NotNull;

public class ClaimChunkHook
implements Listener,
Hook {
    public ClaimChunkHook() {
        ClaimChunkConfig.reload();
    }

    @Override
    public void registerWorld(@NotNull World world) {
        world.getLayerRegistry().register((Keyed)new ClaimChunkLayer(this, world));
    }

    @Override
    public void unloadWorld(@NotNull World world) {
        world.getLayerRegistry().unregister("claimchunk");
    }

    @Override
    @NotNull
    public Collection<Marker<?>> getData(@NotNull World world) {
        IClaimChunkDataHandler dataHandler;
        if (!ConfigUtil.isClaimsEnabled()) {
            return EMPTY_LIST;
        }
        ClaimChunk cc = ClaimChunk.getInstance();
        try {
            Field field = ClaimChunk.class.getDeclaredField("dataHandler");
            field.setAccessible(true);
            dataHandler = (IClaimChunkDataHandler)field.get(cc);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
            return EMPTY_LIST;
        }
        DataChunk[] chunkArr = dataHandler.getClaimedChunks();
        if (chunkArr == null) {
            return EMPTY_LIST;
        }
        List<DataChunk> chunks = Arrays.stream(chunkArr).filter(claim -> claim.chunk.world().equals(world.getName())).toList();
        if (ClaimChunkConfig.SHOW_CHUNKS) {
            return chunks.stream().map(claim -> {
                int minX = claim.chunk.x() << 4;
                int maxX = claim.chunk.x() + 1 << 4;
                int minZ = claim.chunk.z() << 4;
                int maxZ = claim.chunk.z() + 1 << 4;
                String key = String.format("cc_%s_chunk_%d_%d", world.getName(), minX, minZ);
                Rectangle rect = Marker.rectangle((String)key, (Point)Point.of((int)minX, (int)minZ), (Point)Point.of((int)maxX, (int)maxZ));
                return (Rectangle)rect.setOptions(this.options(world, claim.player));
            }).collect(Collectors.toList());
        }
        List<ClaimChunkClaim> claims = chunks.stream().map(chunk -> new ClaimChunkClaim(chunk.chunk.x(), chunk.chunk.x(), chunk.player)).collect(Collectors.toList());
        List<ClaimChunkGroup> groups = this.groupClaims(claims);
        ArrayList markers = new ArrayList();
        for (ClaimChunkGroup group : groups) {
            String key = String.format("cc_%s_chunk_%s", world.getName(), group.id());
            markers.add(ChunkUtil.getPoly(key, group.claims()).setOptions(this.options(world, group.owner())));
        }
        return markers;
    }

    @NotNull
    private Options.Builder options(@NotNull World world, @NotNull UUID owner) {
        OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)owner);
        String ownerName = player.getName() == null ? "unknown" : player.getName();
        return Options.builder().strokeColor(Integer.valueOf(Colors.fromHex((String)ClaimChunkConfig.MARKER_STROKE_COLOR))).strokeWeight(Integer.valueOf(ClaimChunkConfig.MARKER_STROKE_WEIGHT)).fillColor(Integer.valueOf(Colors.fromHex((String)ClaimChunkConfig.MARKER_FILL_COLOR))).fillType(Fill.Type.NONZERO).popupContent(ClaimChunkConfig.MARKER_POPUP.replace("<world>", world.getName()).replace("<owner>", ownerName));
    }

    @NotNull
    private List<ClaimChunkGroup> groupClaims(@NotNull List<ClaimChunkClaim> claims) {
        HashMap<UUID, List> byOwner = new HashMap<UUID, List>();
        for (ClaimChunkClaim claimChunkClaim : claims) {
            List list = byOwner.getOrDefault(claimChunkClaim.owner(), new ArrayList());
            list.add(claimChunkClaim);
            byOwner.put(claimChunkClaim.owner(), list);
        }
        HashMap<UUID, List> groups = new HashMap<UUID, List>();
        for (Map.Entry entry : byOwner.entrySet()) {
            UUID owner = (UUID)entry.getKey();
            List list = (List)entry.getValue();
            block2: for (ClaimChunkClaim claim : list) {
                List groupList = groups.getOrDefault(owner, new ArrayList());
                for (ClaimChunkGroup group : groupList) {
                    if (!group.isTouching(claim)) continue;
                    group.add(claim);
                    continue block2;
                }
                groupList.add(new ClaimChunkGroup(claim, owner));
                groups.put(owner, groupList);
            }
        }
        ArrayList<ClaimChunkGroup> arrayList = new ArrayList<ClaimChunkGroup>();
        for (List list : groups.values()) {
            block5: for (ClaimChunkGroup group : list) {
                for (ClaimChunkGroup toChk : arrayList) {
                    if (!toChk.isTouching(group)) continue;
                    toChk.add(group);
                    continue block5;
                }
                arrayList.add(group);
            }
        }
        return arrayList;
    }
}

