/*
 * Decompiled with CFR 0.152.
 */
package com.ryderbelserion.map.hook.claims.griefprevention;

import com.ryderbelserion.map.hook.Hook;
import com.ryderbelserion.map.hook.claims.griefprevention.GriefPreventionClaim;
import com.ryderbelserion.map.hook.claims.griefprevention.GriefPreventionConfig;
import com.ryderbelserion.map.hook.claims.griefprevention.GriefPreventionLayer;
import com.ryderbelserion.map.util.ConfigUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import me.ryanhamshire.GriefPrevention.Claim;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import net.pl3x.map.core.Keyed;
import net.pl3x.map.core.markers.Point;
import net.pl3x.map.core.markers.marker.Marker;
import net.pl3x.map.core.markers.marker.Rectangle;
import net.pl3x.map.core.markers.option.Options;
import net.pl3x.map.core.util.Colors;
import net.pl3x.map.core.world.World;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Listener;
import org.jetbrains.annotations.NotNull;

public class GriefPreventionHook
implements Listener,
Hook {
    public GriefPreventionHook() {
        GriefPreventionConfig.reload();
    }

    private boolean isWorldEnabled(@NotNull String name) {
        return GriefPrevention.instance.claimsEnabledForWorld(Bukkit.getWorld((String)name));
    }

    @Override
    public void registerWorld(@NotNull World world) {
        if (this.isWorldEnabled(world.getName())) {
            world.getLayerRegistry().register((Keyed)new GriefPreventionLayer(this, world));
        }
    }

    @Override
    public void unloadWorld(@NotNull World world) {
        world.getLayerRegistry().unregister("griefprevention");
    }

    @Override
    @NotNull
    public Collection<Marker<?>> getData(@NotNull World world) {
        if (!ConfigUtil.isClaimsEnabled()) {
            return EMPTY_LIST;
        }
        if (!this.isWorldEnabled(world.getName())) {
            return EMPTY_LIST;
        }
        return GriefPrevention.instance.dataStore.getClaims().stream().filter(claim -> claim.getLesserBoundaryCorner().getWorld().getName().equals(world.getName())).map(claim -> new GriefPreventionClaim(world, (Claim)claim)).map(claim -> {
            String key = "gp-claim-" + claim.getID();
            return (Rectangle)Marker.rectangle((String)key, (Point)claim.getMin(), (Point)claim.getMax()).setOptions(this.getOptions((GriefPreventionClaim)claim));
        }).collect(Collectors.toSet());
    }

    @NotNull
    private Options getOptions(@NotNull GriefPreventionClaim claim) {
        Options.Builder builder = claim.isAdminClaim() ? Options.builder().strokeWeight(Integer.valueOf(GriefPreventionConfig.MARKER_ADMIN_STROKE_WEIGHT)).strokeColor(Integer.valueOf(Colors.fromHex((String)GriefPreventionConfig.MARKER_ADMIN_STROKE_COLOR))).fillColor(Integer.valueOf(Colors.fromHex((String)GriefPreventionConfig.MARKER_ADMIN_FILL_COLOR))).popupContent(this.processPopup(GriefPreventionConfig.MARKER_ADMIN_POPUP, claim)) : Options.builder().strokeWeight(Integer.valueOf(GriefPreventionConfig.MARKER_BASIC_STROKE_WEIGHT)).strokeColor(Integer.valueOf(Colors.fromHex((String)GriefPreventionConfig.MARKER_BASIC_STROKE_COLOR))).fillColor(Integer.valueOf(Colors.fromHex((String)GriefPreventionConfig.MARKER_BASIC_FILL_COLOR))).popupContent(this.processPopup(GriefPreventionConfig.MARKER_BASIC_POPUP, claim));
        return builder.build();
    }

    @NotNull
    private String processPopup(@NotNull String popup, @NotNull GriefPreventionClaim claim) {
        return popup.replace("<world>", claim.getWorld().getName()).replace("<id>", Long.toString(claim.getID())).replace("<owner>", claim.getOwnerName()).replace("<trusts>", this.getTrusts(claim)).replace("<area>", Integer.toString(claim.getArea())).replace("<width>", Integer.toString(claim.getWidth())).replace("<height>", Integer.toString(claim.getHeight()));
    }

    @NotNull
    private String getTrusts(@NotNull GriefPreventionClaim claim) {
        ArrayList<String> builders = new ArrayList<String>();
        ArrayList<String> containers = new ArrayList<String>();
        ArrayList<String> accessors = new ArrayList<String>();
        ArrayList<String> managers = new ArrayList<String>();
        claim.getPermissions(builders, containers, accessors, managers);
        StringBuilder sb = new StringBuilder();
        if (!builders.isEmpty()) {
            if (sb.isEmpty()) {
                sb.append("<hr/>");
            }
            sb.append(GriefPreventionConfig.MARKER_POPUP_TRUST.replace("<builders>", this.getNames(builders)));
        }
        if (!containers.isEmpty()) {
            if (sb.isEmpty()) {
                sb.append("<hr/>");
            }
            sb.append(GriefPreventionConfig.MARKER_POPUP_CONTAINER.replace("<containers>", this.getNames(containers)));
        }
        if (!accessors.isEmpty()) {
            if (sb.isEmpty()) {
                sb.append("<hr/>");
            }
            sb.append(GriefPreventionConfig.MARKER_POPUP_ACCESS.replace("<accessors>", this.getNames(accessors)));
        }
        if (!managers.isEmpty()) {
            if (sb.isEmpty()) {
                sb.append("<hr/>");
            }
            sb.append(GriefPreventionConfig.MARKER_POPUP_PERMISSION.replace("<managers>", this.getNames(managers)));
        }
        return sb.toString();
    }

    @NotNull
    private String getNames(@NotNull List<String> list) {
        ArrayList<String> names = new ArrayList<String>();
        for (String str : list) {
            try {
                UUID uuid = UUID.fromString(str);
                OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)uuid);
                names.add(offlinePlayer.getName());
            }
            catch (Exception e) {
                names.add(str);
            }
        }
        return String.join((CharSequence)", ", names);
    }
}

