/*
 * Decompiled with CFR 0.152.
 */
package com.ryderbelserion.map.marker.mobs;

import com.ryderbelserion.fusion.paper.api.enums.Scheduler;
import com.ryderbelserion.fusion.paper.api.scheduler.FoliaScheduler;
import com.ryderbelserion.map.Pl3xMapExtras;
import com.ryderbelserion.map.config.MobConfig;
import com.ryderbelserion.map.marker.mobs.MobsManager;
import java.util.Collection;
import java.util.Collections;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import net.pl3x.map.core.markers.layer.WorldLayer;
import net.pl3x.map.core.markers.marker.Marker;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.entity.Mob;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MobsLayer
extends WorldLayer {
    @NotNull
    private final Pl3xMapExtras plugin = (Pl3xMapExtras)JavaPlugin.getPlugin(Pl3xMapExtras.class);
    @NotNull
    private final Server server = this.plugin.getServer();
    @NotNull
    private final ComponentLogger logger = this.plugin.getComponentLogger();
    @Nullable
    private final MobsManager mobsManager = this.plugin.getMobsManager();
    public static final String KEY = "pl3xmap_mobs";
    private final MobConfig config;

    public MobsLayer(@NotNull MobConfig config) {
        super(KEY, config.getWorld(), () -> config.LAYER_LABEL);
        this.config = config;
        this.setShowControls(config.LAYER_SHOW_CONTROLS);
        this.setDefaultHidden(config.LAYER_DEFAULT_HIDDEN);
        this.setUpdateInterval(config.LAYER_UPDATE_INTERVAL);
        this.setPriority(config.LAYER_PRIORITY);
        this.setZIndex(config.LAYER_ZINDEX);
    }

    @NotNull
    public Collection<Marker<?>> getMarkers() {
        this.retrieveMarkers();
        if (this.mobsManager == null) {
            return Collections.emptyList();
        }
        return this.mobsManager.getActiveMarkers(this.getWorld().getName());
    }

    private void retrieveMarkers() {
        if (this.mobsManager == null) {
            this.logger.warn("The mob manager instance is null.");
            return;
        }
        final World bukkitWorld = this.server.getWorld(this.config.getWorld().getName());
        if (bukkitWorld == null) {
            return;
        }
        new FoliaScheduler(this.plugin, Scheduler.global_scheduler){

            @Override
            public void run() {
                bukkitWorld.getEntitiesByClass(Mob.class).forEach(mob -> {
                    if (MobsLayer.this.config.ONLY_SHOW_MOBS_EXPOSED_TO_SKY && (double)bukkitWorld.getHighestBlockYAt(mob.getLocation()) > mob.getLocation().getY()) {
                        return;
                    }
                    String key = String.format("%s_%s_%s", MobsLayer.KEY, MobsLayer.this.getWorld().getName(), mob.getUniqueId());
                    MobsLayer.this.mobsManager.addMarker(key, (Mob)mob, MobsLayer.this.config);
                });
            }
        }.runNow();
    }
}

