/*
 * Decompiled with CFR 0.152.
 */
package com.ryderbelserion.map.marker.signs;

import com.ryderbelserion.map.config.SignsConfig;
import com.ryderbelserion.map.marker.signs.Position;
import com.ryderbelserion.map.marker.signs.Sign;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.pl3x.map.core.markers.Point;
import net.pl3x.map.core.markers.Vector;
import net.pl3x.map.core.markers.layer.WorldLayer;
import net.pl3x.map.core.markers.marker.Icon;
import net.pl3x.map.core.markers.marker.Marker;
import net.pl3x.map.core.markers.option.Options;
import org.jetbrains.annotations.NotNull;

public class SignsLayer
extends WorldLayer {
    public static final String KEY = "pl3xmap_signs";
    private final Path dataFile;
    private final SignsConfig config;
    private final Options options;
    private final Map<Position, Sign> signs = new ConcurrentHashMap<Position, Sign>();

    public SignsLayer(@NotNull SignsConfig config) {
        super(KEY, config.getWorld(), () -> config.LAYER_LABEL);
        this.config = config;
        this.dataFile = this.getWorld().getTilesDirectory().resolve("signs.dat");
        this.setShowControls(config.LAYER_SHOW_CONTROLS);
        this.setDefaultHidden(config.LAYER_DEFAULT_HIDDEN);
        this.setUpdateInterval(config.LAYER_UPDATE_INTERVAL);
        this.setPriority(config.LAYER_PRIORITY);
        this.setZIndex(config.LAYER_ZINDEX);
        this.setCss(config.LAYER_CSS);
        this.options = new Options.Builder().popupOffset(Point.of((int)0, (int)10)).popupMaxWidth(Integer.valueOf(196)).popupMinWidth(Integer.valueOf(196)).popupMaxHeight(Integer.valueOf(210)).popupCloseButton(Boolean.valueOf(false)).build();
        this.loadData();
    }

    @NotNull
    public Collection<Marker<?>> getMarkers() {
        return this.signs.values().stream().map(sign -> {
            String key = String.format("%s_%s_%d_%d", KEY, this.getWorld().getName(), sign.pos().x(), sign.pos().z());
            return (Icon)Marker.icon((String)key, (Point)sign.pos().toPoint(), (String)sign.icon().getKey(), (Vector)this.getConfig().ICON_SIZE).setOptions(this.options.asBuilder().popupPane(String.format("%s_popup", sign.icon().getKey())).popupContent(this.getConfig().ICON_POPUP_CONTENT.replace("<line1>", sign.lines().get(0)).replace("<line2>", sign.lines().get(1)).replace("<line3>", sign.lines().get(2)).replace("<line4>", sign.lines().get(3))).build());
        }).collect(Collectors.toList());
    }

    @NotNull
    public SignsConfig getConfig() {
        return this.config;
    }

    @NotNull
    public Collection<Sign> getSigns() {
        return Collections.unmodifiableCollection(this.signs.values());
    }

    public boolean hasSign(@NotNull Position pos) {
        return this.signs.containsKey(pos);
    }

    public void putSign(@NotNull Sign sign) {
        this.signs.put(sign.pos(), sign);
        this.saveData();
    }

    public void removeSign(@NotNull Position pos) {
        this.signs.remove(pos);
        this.saveData();
    }

    private void loadData() {
        if (!Files.exists(this.dataFile, new LinkOption[0])) {
            return;
        }
        try (DataInputStream in = new DataInputStream(new GZIPInputStream(new FileInputStream(this.dataFile.toFile())));){
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                Sign sign = Sign.load(in);
                this.signs.put(sign.pos(), sign);
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private void saveData() {
        try (DataOutputStream out = new DataOutputStream(new GZIPOutputStream(new FileOutputStream(this.dataFile.toFile())));){
            out.writeInt(this.signs.size());
            for (Sign sign : this.signs.values()) {
                sign.save(out);
            }
            out.flush();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

