/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.beanmapper;

import ch.jalu.configme.beanmapper.ConfigMeMapperException;
import ch.jalu.configme.beanmapper.Mapper;
import ch.jalu.configme.beanmapper.context.ExportContext;
import ch.jalu.configme.beanmapper.context.ExportContextImpl;
import ch.jalu.configme.beanmapper.context.MappingContext;
import ch.jalu.configme.beanmapper.context.MappingContextImpl;
import ch.jalu.configme.beanmapper.leafvaluehandler.LeafValueHandler;
import ch.jalu.configme.beanmapper.leafvaluehandler.LeafValueHandlerImpl;
import ch.jalu.configme.beanmapper.propertydescription.BeanDescriptionFactory;
import ch.jalu.configme.beanmapper.propertydescription.BeanDescriptionFactoryImpl;
import ch.jalu.configme.beanmapper.propertydescription.BeanPropertyComments;
import ch.jalu.configme.beanmapper.propertydescription.BeanPropertyDescription;
import ch.jalu.configme.internal.PathUtils;
import ch.jalu.configme.properties.convertresult.ConvertErrorRecorder;
import ch.jalu.configme.properties.convertresult.ValueWithComments;
import ch.jalu.typeresolver.TypeInfo;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MapperImpl
implements Mapper {
    public static final Object RETURN_NULL = new Object();
    private final BeanDescriptionFactory beanDescriptionFactory;
    private final LeafValueHandler leafValueHandler;

    public MapperImpl() {
        this(new BeanDescriptionFactoryImpl(), new LeafValueHandlerImpl(LeafValueHandlerImpl.createDefaultLeafTypes()));
    }

    public MapperImpl(@NotNull BeanDescriptionFactory beanDescriptionFactory, @NotNull LeafValueHandler leafValueHandler) {
        this.beanDescriptionFactory = beanDescriptionFactory;
        this.leafValueHandler = leafValueHandler;
    }

    @NotNull
    protected final BeanDescriptionFactory getBeanDescriptionFactory() {
        return this.beanDescriptionFactory;
    }

    @NotNull
    protected final LeafValueHandler getLeafValueHandler() {
        return this.leafValueHandler;
    }

    @NotNull
    protected MappingContext createRootMappingContext(@NotNull TypeInfo beanType, @NotNull ConvertErrorRecorder errorRecorder) {
        return MappingContextImpl.createRoot(beanType, errorRecorder);
    }

    @NotNull
    protected ExportContext createRootExportContext() {
        return ExportContextImpl.createRoot();
    }

    @Override
    @Nullable
    public Object toExportValue(@NotNull Object value) {
        return this.toExportValue(value, this.createRootExportContext());
    }

    @Nullable
    protected Object toExportValue(@Nullable Object value, @NotNull ExportContext exportContext) {
        Object exportValue = this.leafValueHandler.toExportValue(value, exportContext);
        if (exportValue != null || value == null) {
            return MapperImpl.unwrapReturnNull(exportValue);
        }
        exportValue = this.createExportValueForSpecialTypes(value, exportContext);
        if (exportValue != null) {
            return MapperImpl.unwrapReturnNull(exportValue);
        }
        LinkedHashMap<String, Object> mappedBean = new LinkedHashMap<String, Object>();
        for (BeanPropertyDescription property : this.beanDescriptionFactory.getAllProperties(value.getClass())) {
            Object exportValueOfProperty = this.toExportValue(property.getValue(value), exportContext);
            if (exportValueOfProperty == null) continue;
            BeanPropertyComments propComments = property.getComments();
            if (exportContext.shouldInclude(propComments)) {
                exportContext.registerComment(propComments);
                exportValueOfProperty = new ValueWithComments(exportValueOfProperty, propComments.getComments(), propComments.getUuid());
            }
            mappedBean.put(property.getName(), exportValueOfProperty);
        }
        return mappedBean;
    }

    @Nullable
    protected Object createExportValueForSpecialTypes(@Nullable Object value, @NotNull ExportContext exportContext) {
        if (value instanceof Iterable) {
            int index = 0;
            ArrayList<Object> result = new ArrayList<Object>();
            for (Object entry : (Iterable)value) {
                ExportContext entryContext = exportContext.createChildContext(PathUtils.pathSpecifierForIndex(index));
                result.add(this.toExportValue(entry, entryContext));
                ++index;
            }
            return result;
        }
        if (value instanceof Map) {
            LinkedHashMap result = new LinkedHashMap();
            for (Map.Entry entry : ((Map)value).entrySet()) {
                ExportContext entryContext = exportContext.createChildContext(PathUtils.pathSpecifierForMapKey(entry));
                result.put(entry.getKey(), this.toExportValue(entry.getValue(), entryContext));
            }
            return result;
        }
        if (value instanceof Optional) {
            Optional optional = (Optional)value;
            return optional.map(v -> this.toExportValue(v, exportContext.createChildContext("$opt"))).orElse(RETURN_NULL);
        }
        return null;
    }

    @Nullable
    protected static Object unwrapReturnNull(@Nullable Object o) {
        return o == RETURN_NULL ? null : o;
    }

    @Override
    @Nullable
    public Object convertToBean(@Nullable Object value, @NotNull TypeInfo targetType, @NotNull ConvertErrorRecorder errorRecorder) {
        if (value == null) {
            return null;
        }
        return this.convertValueForType(this.createRootMappingContext(targetType, errorRecorder), value);
    }

    @Nullable
    protected Object convertValueForType(@NotNull MappingContext context, @Nullable Object value) {
        Object result = this.leafValueHandler.convert(value, context);
        if (result != null) {
            return result;
        }
        result = this.convertSpecialTypes(context, value);
        if (result != null) {
            return result;
        }
        return this.createBean(context, value);
    }

    @Nullable
    protected Object convertSpecialTypes(@NotNull MappingContext context, @Nullable Object value) {
        Class<?> rawClass = context.getTargetTypeAsClassOrThrow();
        if (Iterable.class.isAssignableFrom(rawClass)) {
            return this.convertToCollection(context, value);
        }
        if (Map.class.isAssignableFrom(rawClass)) {
            return this.convertToMap(context, value);
        }
        if (Optional.class.isAssignableFrom(rawClass)) {
            return this.convertOptional(context, value);
        }
        return null;
    }

    @Nullable
    protected Collection<?> convertToCollection(@NotNull MappingContext context, @Nullable Object value) {
        if (value instanceof Iterable) {
            TypeInfo entryType = context.getTargetTypeArgumentOrThrow(0);
            Collection<?> result = this.createCollectionMatchingType(context);
            int index = 0;
            for (Object entry : (Iterable)value) {
                MappingContext entryContext = context.createChild(PathUtils.pathSpecifierForIndex(index), entryType);
                Object convertedEntry = this.convertValueForType(entryContext, entry);
                if (convertedEntry == null) {
                    context.registerError("Cannot convert value at index " + index);
                } else {
                    result.add(convertedEntry);
                }
                ++index;
            }
            return result;
        }
        return null;
    }

    @NotNull
    protected Collection<?> createCollectionMatchingType(@NotNull MappingContext mappingContext) {
        Class<AbstractCollection> collectionType = mappingContext.getTargetTypeAsClassOrThrow();
        if (collectionType.isAssignableFrom(ArrayList.class)) {
            return new ArrayList();
        }
        if (collectionType.isAssignableFrom(LinkedHashSet.class)) {
            return new LinkedHashSet();
        }
        throw new ConfigMeMapperException(mappingContext, "Unsupported collection type '" + String.valueOf(collectionType) + "'");
    }

    @Nullable
    protected Map<?, ?> convertToMap(@NotNull MappingContext context, @Nullable Object value) {
        if (value instanceof Map) {
            if (context.getTargetTypeArgumentOrThrow(0).toClass() != String.class) {
                throw new ConfigMeMapperException(context, "The key type of maps may only be of String type");
            }
            TypeInfo mapValueType = context.getTargetTypeArgumentOrThrow(1);
            Map entries = (Map)value;
            Map<?, ?> result = this.createMapMatchingType(context);
            for (Map.Entry entry : entries.entrySet()) {
                MappingContext entryContext = context.createChild(PathUtils.pathSpecifierForMapKey(entry), mapValueType);
                Object mappedValue = this.convertValueForType(entryContext, entry.getValue());
                if (mappedValue == null) {
                    context.registerError("Cannot map value for key " + (String)entry.getKey());
                    continue;
                }
                result.put(entry.getKey(), mappedValue);
            }
            return result;
        }
        return null;
    }

    @NotNull
    protected Map<?, ?> createMapMatchingType(@NotNull MappingContext mappingContext) {
        Class<AbstractMap> mapType = mappingContext.getTargetTypeAsClassOrThrow();
        if (mapType.isAssignableFrom(LinkedHashMap.class)) {
            return new LinkedHashMap();
        }
        if (mapType.isAssignableFrom(TreeMap.class)) {
            return new TreeMap();
        }
        throw new ConfigMeMapperException(mappingContext, "Unsupported map type '" + String.valueOf(mapType) + "'");
    }

    @Nullable
    protected Object convertOptional(@NotNull MappingContext context, @Nullable Object value) {
        MappingContext childContext = context.createChild("$opt", context.getTargetTypeArgumentOrThrow(0));
        Object result = this.convertValueForType(childContext, value);
        return Optional.ofNullable(result);
    }

    @Nullable
    protected Object createBean(@NotNull MappingContext context, @Nullable Object value) {
        if (!(value instanceof Map)) {
            return null;
        }
        Collection<BeanPropertyDescription> properties = this.beanDescriptionFactory.getAllProperties(context.getTargetTypeAsClassOrThrow());
        if (properties.isEmpty()) {
            return null;
        }
        Map entries = (Map)value;
        Object bean = this.createBeanMatchingType(context);
        for (BeanPropertyDescription property : properties) {
            Object result = this.convertValueForType(context.createChild(property.getName(), property.getTypeInformation()), entries.get(property.getName()));
            if (result == null) {
                if (property.getValue(bean) == null) {
                    return null;
                }
                context.registerError("No value found, fallback to field default value");
                continue;
            }
            property.setValue(bean, result);
        }
        return bean;
    }

    @NotNull
    protected Object createBeanMatchingType(@NotNull MappingContext mappingContext) {
        Class<?> clazz = mappingContext.getTargetTypeAsClassOrThrow();
        try {
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new ConfigMeMapperException(mappingContext, "Could not create object of type '" + clazz.getName() + "'. It is required to have a default constructor", e);
        }
    }
}

