/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.beanmapper.context;

import ch.jalu.configme.beanmapper.context.ExportContext;
import ch.jalu.configme.beanmapper.propertydescription.BeanPropertyComments;
import ch.jalu.configme.internal.PathUtils;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public class ExportContextImpl
implements ExportContext {
    private final String beanPath;
    private final Set<UUID> usedUniqueCommentIds;

    protected ExportContextImpl(@NotNull String beanPath, @NotNull Set<UUID> usedUniqueCommentIds) {
        this.beanPath = beanPath;
        this.usedUniqueCommentIds = usedUniqueCommentIds;
    }

    @NotNull
    public static ExportContextImpl createRoot() {
        return new ExportContextImpl("", new HashSet<UUID>());
    }

    @Override
    @NotNull
    public ExportContext createChildContext(@NotNull String path) {
        String childPath = PathUtils.concatSpecifierAware(this.beanPath, path);
        return new ExportContextImpl(childPath, this.usedUniqueCommentIds);
    }

    @Override
    @NotNull
    public String getBeanPath() {
        return this.beanPath;
    }

    @Override
    public boolean shouldInclude(@NotNull BeanPropertyComments comments) {
        return !comments.getComments().isEmpty() && (comments.getUuid() == null || !this.usedUniqueCommentIds.contains(comments.getUuid()));
    }

    @Override
    public void registerComment(@NotNull BeanPropertyComments comments) {
        if (comments.getUuid() != null) {
            this.usedUniqueCommentIds.add(comments.getUuid());
        }
    }
}

