/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.beanmapper.context;

import ch.jalu.configme.beanmapper.context.MappingContext;
import ch.jalu.configme.internal.PathUtils;
import ch.jalu.configme.properties.convertresult.ConvertErrorRecorder;
import ch.jalu.typeresolver.TypeInfo;
import org.jetbrains.annotations.NotNull;

public class MappingContextImpl
implements MappingContext {
    private final String beanPath;
    private final TypeInfo targetType;
    private final ConvertErrorRecorder errorRecorder;

    protected MappingContextImpl(@NotNull String beanPath, @NotNull TypeInfo targetType, @NotNull ConvertErrorRecorder errorRecorder) {
        this.beanPath = beanPath;
        this.targetType = targetType;
        this.errorRecorder = errorRecorder;
    }

    @NotNull
    public static MappingContextImpl createRoot(@NotNull TypeInfo targetType, @NotNull ConvertErrorRecorder errorRecorder) {
        return new MappingContextImpl("", targetType, errorRecorder);
    }

    @Override
    @NotNull
    public MappingContext createChild(@NotNull String subPath, @NotNull TypeInfo targetType) {
        String childPath = PathUtils.concatSpecifierAware(this.beanPath, subPath);
        return new MappingContextImpl(childPath, targetType, this.errorRecorder);
    }

    @Override
    @NotNull
    public String getBeanPath() {
        return this.beanPath;
    }

    @Override
    @NotNull
    public TypeInfo getTargetType() {
        return this.targetType;
    }

    @Override
    @NotNull
    public String createDescription() {
        return "Bean path: '" + this.beanPath + "', type: '" + String.valueOf(this.targetType.getType()) + "'";
    }

    @Override
    @NotNull
    public ConvertErrorRecorder getErrorRecorder() {
        return this.errorRecorder;
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.createDescription() + "]";
    }
}

