/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.beanmapper.leafvaluehandler;

import ch.jalu.configme.beanmapper.context.ExportContext;
import ch.jalu.configme.beanmapper.context.MappingContext;
import ch.jalu.configme.beanmapper.leafvaluehandler.EnumLeafType;
import ch.jalu.configme.beanmapper.leafvaluehandler.LeafValueHandler;
import ch.jalu.configme.beanmapper.leafvaluehandler.MapperLeafType;
import ch.jalu.configme.properties.convertresult.ConvertErrorRecorder;
import ch.jalu.configme.properties.types.BooleanType;
import ch.jalu.configme.properties.types.NumberType;
import ch.jalu.configme.properties.types.RegexType;
import ch.jalu.configme.properties.types.StringType;
import ch.jalu.typeresolver.TypeInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LeafValueHandlerImpl
implements LeafValueHandler {
    private final List<MapperLeafType> leafTypes;

    public LeafValueHandlerImpl(@NotNull @NotNull List<@NotNull MapperLeafType> leafTypes) {
        this.leafTypes = leafTypes;
    }

    public LeafValueHandlerImpl(MapperLeafType ... leafTypes) {
        this.leafTypes = Arrays.stream(leafTypes).collect(Collectors.toList());
    }

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    @NotNull
    public static @NotNull ArrayList<@NotNull MapperLeafType> createDefaultLeafTypes() {
        return Stream.of(BooleanType.BOOLEAN, StringType.STRING, NumberType.INTEGER, NumberType.DOUBLE, NumberType.LONG, new EnumLeafType(), NumberType.FLOAT, NumberType.BYTE, NumberType.SHORT, NumberType.BIG_INTEGER, NumberType.BIG_DECIMAL, RegexType.REGEX).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    @Nullable
    public Object convert(@Nullable Object value, @NotNull MappingContext mappingContext) {
        TypeInfo targetType = mappingContext.getTargetType();
        ConvertErrorRecorder errorRecorder = mappingContext.getErrorRecorder();
        for (MapperLeafType leafType : this.leafTypes) {
            Object result = leafType.convert(value, targetType, errorRecorder);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    @Nullable
    public Object toExportValue(@Nullable Object value, @NotNull ExportContext exportContext) {
        for (MapperLeafType leafType : this.leafTypes) {
            Object exportValue = leafType.toExportValueIfApplicable(value);
            if (exportValue == null) continue;
            return exportValue;
        }
        return null;
    }

    @NotNull
    protected final List<MapperLeafType> getLeafTypes() {
        return this.leafTypes;
    }

    public static final class Builder {
        private final List<MapperLeafType> leafTypes = new ArrayList<MapperLeafType>();

        @NotNull
        public Builder addDefaults() {
            this.leafTypes.addAll(LeafValueHandlerImpl.createDefaultLeafTypes());
            return this;
        }

        @NotNull
        public Builder addType(@NotNull MapperLeafType typeToAdd) {
            this.leafTypes.add(typeToAdd);
            return this;
        }

        @NotNull
        public Builder addTypes(MapperLeafType ... typesToAdd) {
            this.leafTypes.addAll(Arrays.asList(typesToAdd));
            return this;
        }

        @NotNull
        public Builder addTypes(@NotNull Collection<MapperLeafType> typesToAdd) {
            this.leafTypes.addAll(typesToAdd);
            return this;
        }

        @NotNull
        public Builder removeType(@NotNull MapperLeafType typeToRemove) {
            this.leafTypes.remove(typeToRemove);
            return this;
        }

        @NotNull
        public Builder removeMatchingTypes(@NotNull Predicate<MapperLeafType> filterForRemoval) {
            this.leafTypes.removeIf(filterForRemoval);
            return this;
        }

        @NotNull
        public LeafValueHandlerImpl build() {
            return new LeafValueHandlerImpl(new ArrayList<MapperLeafType>(this.leafTypes));
        }
    }
}

