/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.configme.properties.types;

import ch.jalu.configme.properties.convertresult.ConvertErrorRecorder;
import ch.jalu.configme.properties.types.ArrayPropertyType;
import ch.jalu.configme.properties.types.PropertyAndLeafType;
import ch.jalu.typeresolver.TypeInfo;
import ch.jalu.typeresolver.primitives.PrimitiveType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BooleanType
extends PropertyAndLeafType<Boolean> {
    public static final BooleanType BOOLEAN = new BooleanType();

    protected BooleanType() {
        super(Boolean.class);
    }

    @Override
    @Nullable
    public Boolean convert(@Nullable Object object, @NotNull ConvertErrorRecorder errorRecorder) {
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof String) {
            return this.convertFromString((String)object);
        }
        return null;
    }

    @NotNull
    public Boolean toExportValue(@NotNull Boolean value) {
        return value;
    }

    @Override
    public boolean canConvertToType(@NotNull TypeInfo typeInformation) {
        Class<Boolean> requiredClass = PrimitiveType.toReferenceType(typeInformation.toClass());
        return requiredClass != null && requiredClass.isAssignableFrom(Boolean.class);
    }

    @Nullable
    protected Boolean convertFromString(@NotNull String value) {
        if ("true".equalsIgnoreCase(value)) {
            return true;
        }
        if ("false".equalsIgnoreCase(value)) {
            return false;
        }
        return null;
    }

    @NotNull
    public ArrayPropertyType<Boolean> arrayType() {
        return new ArrayPropertyType<Boolean>(this, Boolean[]::new);
    }
}

