/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.typeresolver;

import ch.jalu.typeresolver.array.ArrayTypeUtils;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import org.jetbrains.annotations.Nullable;

public final class CommonTypeUtils {
    private CommonTypeUtils() {
    }

    public static Class<?> getRawType(ParameterizedType parameterizedType) {
        return (Class)parameterizedType.getRawType();
    }

    public static boolean hasExplicitUpperBound(WildcardType wildcardType) {
        Type[] upperBounds = wildcardType.getUpperBounds();
        if (upperBounds.length == 0) {
            return false;
        }
        return !Object.class.equals((Object)upperBounds[0]) || upperBounds.length > 1;
    }

    @Nullable
    public static Class<?> getDefinitiveClass(Type type) {
        GenericArrayType gat;
        Class<?> componentAsClass;
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return CommonTypeUtils.getRawType((ParameterizedType)type);
        }
        if (type instanceof GenericArrayType && (componentAsClass = CommonTypeUtils.getDefinitiveClass((gat = (GenericArrayType)type).getGenericComponentType())) != null) {
            return ArrayTypeUtils.createArrayClass(componentAsClass);
        }
        return null;
    }
}

