/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.typeresolver;

import ch.jalu.typeresolver.TypeToClassUtils;
import ch.jalu.typeresolver.TypeVariableResolver;
import ch.jalu.typeresolver.TypeVisitor;
import ch.jalu.typeresolver.array.ArrayTypeUtils;
import ch.jalu.typeresolver.typeimpl.ParameterizedTypeImpl;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public class TypeInfo {
    private final Type type;
    private transient TypeVariableResolver resolverLazy;

    public TypeInfo(Type type) {
        this.type = type;
    }

    protected TypeInfo() {
        this.type = this.inferTypeForNoArgsConstructor();
    }

    public static TypeInfo of(Type type) {
        return new TypeInfo(type);
    }

    public static TypeInfo of(Field field) {
        return new TypeInfo(field.getGenericType());
    }

    public Type getType() {
        return this.type;
    }

    @Nullable
    public TypeInfo getTypeArgumentInfo(int index) {
        Type[] typeArguments;
        if (this.type instanceof ParameterizedType && index < (typeArguments = ((ParameterizedType)this.type).getActualTypeArguments()).length) {
            return new TypeInfo(typeArguments[index]);
        }
        return null;
    }

    @Nullable
    public Class<?> getTypeArgumentAsClass(int index) {
        TypeInfo genericTypeInfo = this.getTypeArgumentInfo(index);
        return genericTypeInfo == null ? null : genericTypeInfo.toClass();
    }

    @Nullable
    public Class<?> toClass() {
        return TypeToClassUtils.getSafeToWriteClass(this.type);
    }

    public Class<?> getSafeToReadClass() {
        return TypeToClassUtils.getSafeToReadClass(this.type);
    }

    public boolean equalTo(Class<?> clazz) {
        return clazz.equals(this.toClass());
    }

    public boolean isAssignableFrom(Class<?> clazz) {
        Class<?> thisClass = this.toClass();
        return thisClass != null && thisClass.isAssignableFrom(clazz);
    }

    @Nullable
    public TypeInfo getEnclosingType() {
        Type enclosingType = null;
        if (this.type instanceof Class) {
            enclosingType = ((Class)this.type).getEnclosingClass();
        } else if (this.type instanceof ParameterizedType) {
            enclosingType = ((ParameterizedType)this.type).getOwnerType();
        }
        return enclosingType == null ? null : TypeInfo.of(enclosingType);
    }

    @Nullable
    public TypeInfo getComponentType() {
        Type componentType = null;
        if (this.type instanceof Class) {
            componentType = ((Class)this.type).getComponentType();
        } else if (this.type instanceof GenericArrayType) {
            componentType = ((GenericArrayType)this.type).getGenericComponentType();
        }
        return componentType == null ? null : TypeInfo.of(componentType);
    }

    public TypeInfo resolve(Type type) {
        Type resolvedType = type instanceof Class ? type : this.getOrInitResolver().resolve(type);
        return new TypeInfo(resolvedType);
    }

    @Nullable
    public TypeInfo resolveSuperclass(Class<?> clazz) {
        Class<?> thisClass = this.toClass();
        if (thisClass == null || !clazz.isAssignableFrom(thisClass)) {
            return null;
        }
        if (clazz.isArray()) {
            TypeInfo resolvedComponent = this.getComponentType().resolveSuperclass(clazz.getComponentType());
            return TypeInfo.of(ArrayTypeUtils.createArrayType(resolvedComponent.getType()));
        }
        if (clazz.getTypeParameters().length > 0) {
            TypeVariableResolver resolver = this.getOrInitResolver();
            return new TypeInfo(new ParameterizedTypeImpl(clazz, this.getOwnerTypeForResolvedParameterizedType(clazz), resolver.resolveTypes(clazz.getTypeParameters())));
        }
        return new TypeInfo(clazz);
    }

    public Set<Type> getAllTypes() {
        return TypeVisitor.gatherAllTypes(this.type, this.getOrInitResolver());
    }

    public Set<TypeInfo> getAllTypeInfos() {
        return TypeVisitor.gatherAllTypes(this.type, this.getOrInitResolver(), new HashSet(), TypeInfo::new);
    }

    public void visitAllTypes(Consumer<Type> typeVisitor) {
        TypeVisitor.visitAllTypes(this.type, this.getOrInitResolver(), typeVisitor);
    }

    @Nullable
    private Type getOwnerTypeForResolvedParameterizedType(Class<?> superclass) {
        Class<?> enclosingClass = superclass.getEnclosingClass();
        if (enclosingClass == null || Modifier.isStatic(superclass.getModifiers())) {
            return enclosingClass;
        }
        for (TypeInfo enclosingInfo = this.getEnclosingType(); enclosingInfo != null; enclosingInfo = enclosingInfo.getEnclosingType()) {
            TypeInfo resolvedEnclosingType = enclosingInfo.resolveSuperclass(enclosingClass);
            if (resolvedEnclosingType == null) continue;
            return resolvedEnclosingType.getType();
        }
        throw new IllegalStateException("Could not resolve enclosing class '" + enclosingClass + "' from " + this.type);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof TypeInfo) {
            return Objects.equals(this.type, ((TypeInfo)obj).type);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.type);
    }

    public String toString() {
        return "TypeInfo[type=" + this.type + "]";
    }

    protected Type inferTypeForNoArgsConstructor() {
        throw new UnsupportedOperationException();
    }

    private TypeVariableResolver getOrInitResolver() {
        if (this.resolverLazy == null) {
            this.resolverLazy = new TypeVariableResolver(this.type);
        }
        return this.resolverLazy;
    }
}

