/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.typeresolver.numbers;

import ch.jalu.typeresolver.numbers.NumberType;
import ch.jalu.typeresolver.numbers.StandardNumberType;
import ch.jalu.typeresolver.numbers.ValueRange;
import ch.jalu.typeresolver.numbers.ValueRangeComparison;
import ch.jalu.typeresolver.numbers.ValueRangeImpl;
import java.math.BigDecimal;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;

public final class MoreNumberTypes {
    public static final NumberType<Character> CHARACTER = new CharacterNumberType();
    public static final NumberType<AtomicInteger> ATOMIC_INTEGER = new AtomicNumberType<Integer, AtomicInteger>(AtomicInteger.class, StandardNumberType.TYPE_INTEGER, AtomicInteger::new);
    public static final NumberType<AtomicLong> ATOMIC_LONG = new AtomicNumberType<Long, AtomicLong>(AtomicLong.class, StandardNumberType.TYPE_LONG, AtomicLong::new);

    private MoreNumberTypes() {
    }

    private static class CharacterNumberType
    implements NumberType<Character> {
        private final int maxValue = 65535;
        private final int minValue = 0;

        CharacterNumberType() {
        }

        @Override
        public Class<Character> getType() {
            return Character.class;
        }

        @Override
        public Character convertUnsafe(Number number) {
            return Character.valueOf((char)number.intValue());
        }

        @Override
        public ValueRangeComparison compareToValueRange(Number number) {
            ValueRangeComparison rangeComparison = StandardNumberType.TYPE_INTEGER.compareToValueRange(number);
            if (rangeComparison == ValueRangeComparison.WITHIN_RANGE) {
                int intValue = StandardNumberType.TYPE_INTEGER.convertUnsafe(number);
                if (intValue > 65535) {
                    return ValueRangeComparison.ABOVE_MAXIMUM;
                }
                if (intValue < 0) {
                    return ValueRangeComparison.BELOW_MINIMUM;
                }
            }
            return rangeComparison;
        }

        @Override
        public Character convertToBounds(Number numberToConvert) {
            int result = StandardNumberType.TYPE_INTEGER.convertToBounds(numberToConvert);
            if (result > 65535) {
                return Character.valueOf('\uffff');
            }
            if (result < 0) {
                return Character.valueOf('\u0000');
            }
            return Character.valueOf((char)result);
        }

        @Override
        public ValueRange<Character> getValueRange() {
            return new ValueRangeImpl<Character>(Character.valueOf('\u0000'), Character.valueOf('\uffff'), BigDecimal.valueOf(0L), BigDecimal.valueOf(65535L), false, false);
        }
    }

    private static final class AtomicNumberType<B extends Number, A extends Number>
    implements NumberType<A> {
        private final Class<A> type;
        private final NumberType<B> baseType;
        private final Function<B, A> toAtomicFn;

        AtomicNumberType(Class<A> type, NumberType<B> baseType, Function<B, A> toAtomicFn) {
            this.type = type;
            this.baseType = baseType;
            this.toAtomicFn = toAtomicFn;
        }

        @Override
        public Class<A> getType() {
            return this.type;
        }

        @Override
        public A convertUnsafe(Number number) {
            Number value = (Number)this.baseType.convertUnsafe(number);
            return (A)((Number)this.toAtomicFn.apply(value));
        }

        @Override
        public A convertToBounds(Number numberToConvert) {
            Number value = (Number)this.baseType.convertToBounds(numberToConvert);
            return (A)((Number)this.toAtomicFn.apply(value));
        }

        @Override
        public ValueRangeComparison compareToValueRange(Number number) {
            return this.baseType.compareToValueRange(number);
        }

        @Override
        public ValueRange<A> getValueRange() {
            ValueRange<B> baseValueRange = this.baseType.getValueRange();
            Number atomicMinValue = (Number)this.toAtomicFn.apply(baseValueRange.getMinInOwnType());
            Number atomicMaxValue = (Number)this.toAtomicFn.apply(baseValueRange.getMaxInOwnType());
            return new ValueRangeImpl<Number>(atomicMinValue, atomicMaxValue, baseValueRange.getMinValue(), baseValueRange.getMaxValue(), false, false);
        }
    }
}

