/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.typeresolver.typeimpl;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import java.util.Objects;

public class GenericArrayTypeImpl
implements GenericArrayType {
    private final Type genericComponentType;

    public GenericArrayTypeImpl(Type genericComponentType) {
        this.genericComponentType = genericComponentType;
    }

    public static Type create(Type genericComponentType, int dimension) {
        if (dimension < 0) {
            throw new IllegalArgumentException("The dimension may not be negative");
        }
        Type type = genericComponentType;
        for (int i = 0; i < dimension; ++i) {
            type = new GenericArrayTypeImpl(type);
        }
        return type;
    }

    @Override
    public Type getGenericComponentType() {
        return this.genericComponentType;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof GenericArrayType) {
            return Objects.equals(this.genericComponentType, ((GenericArrayType)obj).getGenericComponentType());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.genericComponentType);
    }

    public String toString() {
        String type = this.genericComponentType instanceof Class ? ((Class)this.genericComponentType).getName() : this.genericComponentType.toString();
        return type + "[]";
    }
}

