/*
 * Decompiled with CFR 0.152.
 */
package com.ryderbelserion.fusion.core.api.utils;

import com.ryderbelserion.fusion.core.FusionProvider;
import com.ryderbelserion.fusion.core.api.FusionCore;
import com.ryderbelserion.fusion.core.api.enums.FileAction;
import com.ryderbelserion.fusion.core.api.exceptions.FusionException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileUtils {
    private static final FusionCore fusion = FusionProvider.get();
    private static final Path dataFolder = fusion.getPath();

    public static void extract(@NotNull String input, @NotNull Path output, @NotNull List<FileAction> actions) {
        Path content = output.resolve(input);
        if (actions.contains((Object)FileAction.DELETE_FILE)) {
            try {
                Files.walkFileTree(content, new SimplePathVisitor());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (Files.exists(content, new LinkOption[0])) {
            fusion.log("info", "Cannot extract folder {} to {}, because it already exists @ {}.", input, output, content);
            return;
        }
        boolean isFolder = actions.contains((Object)FileAction.EXTRACT_FOLDER);
        if (isFolder && Files.isDirectory(content, new LinkOption[0])) {
            try {
                Files.createDirectory(content, new FileAttribute[0]);
            }
            catch (IOException exception) {
                throw new FusionException("Failed to create folder " + String.valueOf(content), exception);
            }
        }
        String parentName = content.getParent().getFileName().toString();
        String fileName = content.getFileName().toString();
        Path value = Paths.get(parentName, new String[0]).resolve(fileName);
        boolean isFile = actions.contains((Object)FileAction.EXTRACT_FILE);
        String text = isFile ? value.toString().replace("\\", "/") : input;
        try (JarFile jar = new JarFile(Path.of(FusionCore.class.getProtectionDomain().getCodeSource().getLocation().toURI()).toFile());){
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                Path target;
                JarEntry entry = entries.nextElement();
                String entryName = entry.getName();
                if (entryName.endsWith(".class") || entryName.startsWith("META-INF") || (isFile ? !entryName.equals(text) : !entryName.startsWith(text))) continue;
                boolean isDirectory = entry.isDirectory();
                Path path = target = isFile ? output.resolve(input) : output.resolve(entryName);
                if (isDirectory) {
                    Files.createDirectories(target, new FileAttribute[0]);
                    continue;
                }
                InputStream stream = jar.getInputStream(entry);
                try {
                    Path parent = target.getParent();
                    if (isFile || isFolder && !Files.exists(parent, new LinkOption[0])) {
                        Files.createDirectories(parent, new FileAttribute[0]);
                    }
                    if (Files.exists(target, new LinkOption[0])) continue;
                    Files.copy(stream, target, new CopyOption[0]);
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
        }
        catch (IOException | URISyntaxException exception) {
            fusion.log("warn", "Failed to extract file {} to {}! Exception: {}", text, content, exception);
        }
    }

    public static List<String> getNamesByExtension(@NotNull String folder, @NotNull Path path, @NotNull String extension, int depth) {
        List<Path> files = FileUtils.getFiles(folder.isEmpty() ? path : path.resolve(folder), List.of(extension), depth);
        ArrayList<String> names = new ArrayList<String>();
        for (Path file : files) {
            String name = file.getFileName().toString();
            if (!name.endsWith(extension)) continue;
            names.add(name);
        }
        return names;
    }

    public static List<String> getNamesByExtension(@NotNull String folder, @NotNull Path path, @NotNull String extension) {
        return FileUtils.getNamesByExtension(folder, path, extension, fusion.getDepth());
    }

    public static List<String> getNamesWithoutExtension(@NotNull String folder, @NotNull Path path, @NotNull String extension, int depth) {
        List<Path> files = FileUtils.getFiles(folder.isEmpty() ? path : path.resolve(folder), List.of(extension), depth);
        ArrayList<String> names = new ArrayList<String>();
        for (Path file : files) {
            String name = file.getFileName().toString().replace(extension, "");
            if (names.contains(name)) continue;
            names.add(name);
        }
        return names;
    }

    public static List<String> getNamesWithoutExtension(@NotNull String folder, @NotNull Path path, @NotNull String extension) {
        return FileUtils.getNamesWithoutExtension(folder, path, extension, fusion.getDepth());
    }

    public static List<Path> getFiles(@NotNull Path path, final @NotNull List<String> extensions, int depth) {
        final ArrayList<Path> files = new ArrayList<Path>();
        if (Files.isDirectory(path, new LinkOption[0])) {
            try {
                Files.walkFileTree(path, new HashSet<FileVisitOption>(), Math.max(depth, 1), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    @NotNull
                    public FileVisitResult visitFile(@NotNull Path path, @NotNull BasicFileAttributes attributes) {
                        String name = path.getFileName().toString();
                        extensions.forEach(extension -> {
                            if (name.endsWith((String)extension)) {
                                files.add(path);
                            }
                        });
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException exception) {
                throw new FusionException("Failed to get a list of files", exception);
            }
        }
        return files;
    }

    public static List<Path> getFiles(@NotNull String folder, @NotNull Path path, @NotNull String extension) {
        return FileUtils.getFiles(folder.isEmpty() ? path : path.resolve(folder), List.of(extension), fusion.getDepth());
    }

    public static List<Path> getFiles(@NotNull Path path, @NotNull String extension, int depth) {
        return FileUtils.getFiles(path, List.of(extension), depth);
    }

    public static List<Path> getFiles(@NotNull Path path, @NotNull List<String> extensions) {
        return FileUtils.getFiles(path, extensions, fusion.getDepth());
    }

    public static List<Path> getFiles(@NotNull Path path, @NotNull String extension) {
        return FileUtils.getFiles(path, List.of(extension), fusion.getDepth());
    }

    public static void write(@NotNull Path path, @NotNull String format) {
        try {
            Files.writeString(path, (CharSequence)format, StandardOpenOption.APPEND);
        }
        catch (IOException exception) {
            throw new FusionException(String.format("Failed to write %s to %s", format, path), exception);
        }
    }

    public static void compress(@NotNull List<Path> paths, @NotNull Path directory, @NotNull String content, @NotNull List<FileAction> actions) throws IOException {
        for (Path path : paths) {
            FileUtils.compress(path, directory, content, actions);
        }
    }

    public static void deleteDirectory(@NotNull Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0]) || !Files.isDirectory(path, new LinkOption[0])) {
            return;
        }
        try (DirectoryStream<Path> contents = Files.newDirectoryStream(path);){
            for (Path entry : contents) {
                if (Files.isDirectory(entry, new LinkOption[0])) {
                    FileUtils.deleteDirectory(entry);
                    continue;
                }
                Files.delete(entry);
            }
        }
        Files.deleteIfExists(path);
    }

    public static void compress(@NotNull Path path, @Nullable Path directory, @NotNull String content, @NotNull List<FileAction> actions) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        if (!content.isEmpty()) {
            builder.append(content);
        }
        builder.append(".gz");
        Path file = directory == null ? dataFolder : directory.resolve(builder.toString());
        boolean isDelete = actions.contains((Object)FileAction.DELETE_FILE);
        if (Files.isDirectory(path, new LinkOption[0])) {
            try (ZipOutputStream output = new ZipOutputStream(Files.newOutputStream(file, new OpenOption[0]));
                 Stream<Path> values = Files.walk(path, new FileVisitOption[0]);){
                List<Path> entries = values.filter(key -> !Files.isDirectory(key, new LinkOption[0])).toList();
                for (Path entry : entries) {
                    long size = Files.size(entry);
                    if (size > 0L) {
                        ZipEntry zipEntry = new ZipEntry(entry.toString());
                        output.putNextEntry(zipEntry);
                        Files.copy(entry, output);
                        output.closeEntry();
                    }
                    if (!isDelete) continue;
                    Files.deleteIfExists(entry);
                }
            }
            return;
        }
        long size = Files.size(path);
        if (size > 0L) {
            try (ZipOutputStream output = new ZipOutputStream(Files.newOutputStream(file, new OpenOption[0]));){
                ZipEntry zipEntry = new ZipEntry(path.toString());
                output.putNextEntry(zipEntry);
                Files.copy(path, output);
                output.closeEntry();
            }
        }
        if (isDelete) {
            Files.deleteIfExists(path);
        }
    }

    private static class SimplePathVisitor
    extends SimpleFileVisitor<Path> {
        private SimplePathVisitor() {
        }

        @Override
        @NotNull
        public FileVisitResult visitFile(@NotNull Path file, @NotNull BasicFileAttributes attributes) throws IOException {
            Files.delete(file);
            return FileVisitResult.CONTINUE;
        }

        @Override
        @NotNull
        public FileVisitResult postVisitDirectory(@NotNull Path directory, IOException exception) throws IOException {
            Files.delete(directory);
            return FileVisitResult.CONTINUE;
        }
    }
}

