/*
 * Decompiled with CFR 0.152.
 */
package com.ryderbelserion.fusion.paper.api.builders.gui.types;

import com.ryderbelserion.fusion.paper.api.builders.gui.enums.InteractionComponent;
import com.ryderbelserion.fusion.paper.api.builders.gui.interfaces.GuiItem;
import com.ryderbelserion.fusion.paper.api.builders.gui.interfaces.types.IPaginatedGui;
import com.ryderbelserion.fusion.paper.api.builders.gui.types.BaseGui;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PaginatedGui
extends BaseGui
implements IPaginatedGui {
    private final List<GuiItem> pageItems = new ArrayList<GuiItem>();
    private final Map<Integer, GuiItem> currentPage;
    private int pageNumber = 1;
    private int pageSize;

    public PaginatedGui(@NotNull JavaPlugin plugin, @NotNull String title, int pageSize, int rows, @NotNull Set<InteractionComponent> components) {
        super(plugin, title, rows, components);
        if (pageSize == 0) {
            this.calculatePageSize();
        } else {
            this.pageSize = pageSize;
        }
        int size = rows * 9;
        this.currentPage = new LinkedHashMap<Integer, GuiItem>(size);
    }

    @Override
    public final PaginatedGui setPageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public void addItem(@NotNull GuiItem guiItem) {
        this.pageItems.add(guiItem);
    }

    @Override
    public void addItem(GuiItem ... items) {
        this.pageItems.addAll(Arrays.asList(items));
    }

    @Override
    public void removePageItem(int slot) {
        if (!this.currentPage.containsKey(slot)) {
            return;
        }
        GuiItem guiItem = this.currentPage.remove(slot);
        this.pageItems.remove(guiItem);
        this.updatePage();
    }

    @Override
    public void updatePageItem(int slot, @NotNull ItemStack itemStack) {
        if (!this.currentPage.containsKey(slot)) {
            return;
        }
        GuiItem guiItem = this.currentPage.get(slot);
        guiItem.setItemStack(itemStack);
        this.getInventory().setItem(slot, guiItem.getItemStack());
    }

    @Override
    public void updatePageItem(int row, int col, @NotNull ItemStack itemStack) {
        this.updatePageItem(this.getSlotFromRowColumn(row, col), itemStack);
    }

    @Override
    public void updatePageItem(int row, int col, @NotNull GuiItem guiItem) {
        this.updatePageItem(this.getSlotFromRowColumn(row, col), guiItem);
    }

    @Override
    public void updatePageItem(int slot, @NotNull GuiItem guiItem) {
        if (!this.currentPage.containsKey(slot)) {
            return;
        }
        int index = this.pageItems.indexOf(this.currentPage.get(slot));
        this.currentPage.put(slot, guiItem);
        this.pageItems.set(index, guiItem);
        this.getInventory().setItem(slot, guiItem.getItemStack());
    }

    @Override
    public void open(@NotNull Player player, boolean purge) {
        this.open(player, 1, null);
    }

    @Override
    public void open(@NotNull Player player) {
        this.open(player, 1, null);
    }

    @Override
    public void open(@NotNull Player player, @NotNull Consumer<PaginatedGui> consumer) {
        this.open(player, 1, consumer);
    }

    @Override
    public void open(@NotNull Player player, int openPage, @Nullable Consumer<PaginatedGui> consumer) {
        if (player.isSleeping()) {
            return;
        }
        if (openPage <= this.getMaxPages() || openPage > 0) {
            this.pageNumber = openPage;
        }
        this.getInventory().clear();
        this.currentPage.clear();
        this.populate();
        if (this.pageSize == 0 || this.pageSize == this.getSize()) {
            this.calculatePageSize();
        }
        this.populatePage();
        if (consumer != null) {
            consumer.accept(this);
        }
        player.openInventory(this.getInventory());
    }

    @Override
    public final int getNextPageNumber() {
        if (this.pageNumber + 1 > this.getMaxPages()) {
            return this.pageNumber;
        }
        return this.pageNumber + 1;
    }

    @Override
    public final int getPreviousPageNumber() {
        if (this.pageNumber - 1 == 0) {
            return this.pageNumber;
        }
        return this.pageNumber - 1;
    }

    @Override
    public final boolean next() {
        if (this.pageNumber + 1 > this.getMaxPages()) {
            return false;
        }
        ++this.pageNumber;
        this.updatePage();
        return true;
    }

    @Override
    public final boolean previous() {
        if (this.pageNumber - 1 == 0) {
            return false;
        }
        --this.pageNumber;
        this.updatePage();
        return true;
    }

    @Override
    @Nullable
    public final GuiItem getPageItem(int slot) {
        return this.currentPage.get(slot);
    }

    @Override
    public void setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
    }

    @Override
    public final int getCurrentPageNumber() {
        return this.pageNumber;
    }

    @Override
    @NotNull
    public final List<GuiItem> getItemsFromPage(int givenPage) {
        int page = givenPage - 1;
        ArrayList<GuiItem> guiPage = new ArrayList<GuiItem>();
        int max = page * this.pageSize + this.pageSize;
        if (max > this.pageItems.size()) {
            max = this.pageItems.size();
        }
        for (int i = page * this.pageSize; i < max; ++i) {
            guiPage.add(this.pageItems.get(i));
        }
        return guiPage;
    }

    @Override
    @NotNull
    public final Map<Integer, GuiItem> getCurrentPageItems() {
        return this.currentPage;
    }

    @Override
    public void clearPageContents() {
        for (Map.Entry<Integer, GuiItem> entry : this.currentPage.entrySet()) {
            this.getInventory().setItem(entry.getKey().intValue(), null);
        }
    }

    @Override
    public void clearPageItems(boolean update) {
        this.pageItems.clear();
        if (update) {
            this.updatePage();
        }
    }

    @Override
    public void clearPageItems() {
        this.clearPageItems(false);
    }

    @Override
    public final int getMaxPages() {
        if (this.pageSize == 0) {
            this.pageSize = this.calculatePageSize();
        }
        return (int)Math.ceil((double)this.pageItems.size() / (double)this.pageSize);
    }

    @Override
    public void populatePage() {
        int slot = 0;
        int inventorySize = this.getInventory().getSize();
        Iterator<GuiItem> iterator = this.getItemsFromPage(this.pageNumber).iterator();
        while (iterator.hasNext() && slot < inventorySize) {
            if (this.getGuiItem(slot) != null || this.getInventory().getItem(slot) != null) {
                ++slot;
                continue;
            }
            GuiItem guiItem = iterator.next();
            this.currentPage.put(slot, guiItem);
            this.getInventory().setItem(slot, guiItem.getItemStack());
            ++slot;
        }
    }

    @Override
    public void updatePage() {
        this.clearPageContents();
        this.populatePage();
    }

    @Override
    public final int calculatePageSize() {
        int counter = 0;
        for (int slot = 0; slot < this.getSize(); ++slot) {
            if (this.getGuiItem(slot) != null) continue;
            ++counter;
        }
        this.pageSize = Math.max(1, counter);
        return this.pageSize;
    }

    @Override
    public void updateInventory(@NotNull Player player) {
        this.getInventory().clear();
        this.populate();
    }
}

