/*
 * Decompiled with CFR 0.152.
 */
package com.ryderbelserion.map;

import com.ryderbelserion.map.api.enums.Permissions;
import com.ryderbelserion.map.config.PluginConfig;
import com.ryderbelserion.map.util.ModuleUtil;
import io.papermc.paper.command.brigadier.BasicCommand;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.jetbrains.annotations.NotNull;

public class BaseCommand
implements BasicCommand {
    public void execute(@NotNull CommandSourceStack stack, @NotNull @NotNull String @NotNull [] args) {
        CommandSender sender = stack.getSender();
        switch (args.length) {
            case 0: {
                this.help(sender);
                break;
            }
            case 1: {
                if (args[0].equalsIgnoreCase("reload")) {
                    if (!Permissions.reload.hasPermission(sender) && !(sender instanceof ConsoleCommandSender)) {
                        sender.sendRichMessage(PluginConfig.no_permission.replace("{prefix}", PluginConfig.msg_prefix));
                        return;
                    }
                    PluginConfig.reload();
                    ModuleUtil.toggleAll(false);
                    ModuleUtil.extract();
                    sender.sendRichMessage(PluginConfig.reload_plugin.replace("{prefix}", PluginConfig.msg_prefix));
                    return;
                }
                this.help(sender);
            }
        }
    }

    @NotNull
    public Collection<String> suggest(@NotNull CommandSourceStack stack, @NotNull @NotNull String @NotNull [] args) {
        ArrayList<String> suggestions = new ArrayList<String>();
        if (args.length == 0) {
            if (Permissions.reload.hasPermission(stack.getSender())) {
                suggestions.add("reload");
            }
            if (Permissions.help.hasPermission(stack.getSender())) {
                suggestions.add("help");
            }
        }
        return suggestions;
    }

    private void help(@NotNull CommandSender sender) {
        if (!Permissions.help.hasPermission(sender)) {
            sender.sendRichMessage(PluginConfig.no_permission.replace("{prefix}", PluginConfig.msg_prefix));
            return;
        }
        sender.sendRichMessage(this.convertList(PluginConfig.help_message).replace("{prefix}", PluginConfig.msg_prefix));
    }

    private String convertList(@NotNull List<String> list) {
        if (list.isEmpty()) {
            return "";
        }
        StringBuilder message = new StringBuilder();
        for (String line : list) {
            message.append(line).append("\n");
        }
        return StringUtils.chomp((String)message.toString());
    }
}

