/*
 * Decompiled with CFR 0.152.
 */
package com.ryderbelserion.map.hook.claims.griefdefender;

import com.griefdefender.api.GriefDefender;
import com.griefdefender.api.claim.Claim;
import com.ryderbelserion.map.hook.Hook;
import com.ryderbelserion.map.hook.claims.griefdefender.GriefDefenderClaim;
import com.ryderbelserion.map.hook.claims.griefdefender.GriefDefenderConfig;
import com.ryderbelserion.map.hook.claims.griefdefender.GriefDefenderLayer;
import com.ryderbelserion.map.util.ConfigUtil;
import java.util.Collection;
import java.util.stream.Collectors;
import net.pl3x.map.core.Keyed;
import net.pl3x.map.core.markers.Point;
import net.pl3x.map.core.markers.marker.Marker;
import net.pl3x.map.core.markers.marker.Rectangle;
import net.pl3x.map.core.markers.option.Options;
import net.pl3x.map.core.util.Colors;
import net.pl3x.map.core.world.World;
import org.bukkit.event.Listener;
import org.jetbrains.annotations.NotNull;

public class GriefDefenderHook
implements Listener,
Hook {
    public GriefDefenderHook() {
        GriefDefenderConfig.reload();
    }

    @Override
    public void registerWorld(@NotNull World world) {
        world.getLayerRegistry().register((Keyed)new GriefDefenderLayer(this, world));
    }

    @Override
    public void unloadWorld(@NotNull World world) {
        world.getLayerRegistry().unregister("griefdefender");
    }

    @Override
    @NotNull
    public Collection<Marker<?>> getData(@NotNull World world) {
        if (!ConfigUtil.isClaimsEnabled()) {
            return EMPTY_LIST;
        }
        return GriefDefender.getCore().getAllClaims().stream().filter(claim -> claim.getWorldName().equals(world.getName())).map(claim -> new GriefDefenderClaim(world, (Claim)claim)).map(claim -> {
            String key = "gd-claim-" + String.valueOf(claim.getID());
            return (Rectangle)Marker.rectangle((String)key, (Point)claim.getMin(), (Point)claim.getMax()).setOptions(this.getOptions((GriefDefenderClaim)claim));
        }).collect(Collectors.toSet());
    }

    @NotNull
    private Options getOptions(@NotNull GriefDefenderClaim claim) {
        Options.Builder builder = claim.isAdminClaim() ? Options.builder().strokeWeight(Integer.valueOf(GriefDefenderConfig.MARKER_ADMIN_STROKE_WEIGHT)).strokeColor(Integer.valueOf(Colors.fromHex((String)GriefDefenderConfig.MARKER_ADMIN_STROKE_COLOR))).fillColor(Integer.valueOf(Colors.fromHex((String)GriefDefenderConfig.MARKER_ADMIN_FILL_COLOR))).popupContent(this.processPopup(GriefDefenderConfig.MARKER_ADMIN_POPUP, claim)) : Options.builder().strokeWeight(Integer.valueOf(GriefDefenderConfig.MARKER_BASIC_STROKE_WEIGHT)).strokeColor(Integer.valueOf(Colors.fromHex((String)GriefDefenderConfig.MARKER_BASIC_STROKE_COLOR))).fillColor(Integer.valueOf(Colors.fromHex((String)GriefDefenderConfig.MARKER_BASIC_FILL_COLOR))).popupContent(this.processPopup(GriefDefenderConfig.MARKER_BASIC_POPUP, claim));
        return builder.build();
    }

    @NotNull
    private String processPopup(@NotNull String popup, @NotNull GriefDefenderClaim claim) {
        return popup.replace("<world>", claim.getWorld().getName()).replace("<id>", claim.getID().toString()).replace("<owner>", claim.getOwnerName()).replace("<area>", Integer.toString(claim.getArea())).replace("<width>", Integer.toString(claim.getWidth())).replace("<height>", Integer.toString(claim.getHeight()));
    }
}

