/*
 * Decompiled with CFR 0.152.
 */
package com.ryderbelserion.map.hook.claims.griefprevention;

import java.util.ArrayList;
import java.util.UUID;
import me.ryanhamshire.GriefPrevention.Claim;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import me.ryanhamshire.GriefPrevention.Messages;
import net.pl3x.map.core.markers.Point;
import net.pl3x.map.core.world.World;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;

public class GriefPreventionClaim {
    private final World world;
    private final Claim claim;
    private final Point min;
    private final Point max;
    private UUID ownerId;
    private String ownerName;

    public GriefPreventionClaim(@NotNull World world, @NotNull Claim claim) {
        this.world = world;
        this.claim = claim;
        Location min = this.claim.getLesserBoundaryCorner();
        Location max = this.claim.getGreaterBoundaryCorner();
        this.min = Point.of((double)min.getX(), (double)min.getZ());
        this.max = Point.of((double)max.getX(), (double)max.getZ());
    }

    @NotNull
    public World getWorld() {
        return this.world;
    }

    public boolean isAdminClaim() {
        return this.claim.isAdminClaim();
    }

    @NotNull
    public Long getID() {
        return this.claim.getID();
    }

    @NotNull
    public String getOwnerName() {
        if (this.isAdminClaim()) {
            return GriefPrevention.instance.dataStore.getMessage(Messages.OwnerNameForAdminClaims, new String[0]);
        }
        if (this.claim.getOwnerID() != this.ownerId) {
            this.ownerId = this.claim.getOwnerID();
            this.ownerName = this.claim.getOwnerName();
        }
        return this.ownerName;
    }

    @NotNull
    public Point getMin() {
        return this.min;
    }

    @NotNull
    public Point getMax() {
        return this.max;
    }

    public int getArea() {
        return this.claim.getArea();
    }

    public int getWidth() {
        return this.claim.getWidth();
    }

    public int getHeight() {
        return this.claim.getHeight();
    }

    public void getPermissions(@NotNull ArrayList<String> builders, @NotNull ArrayList<String> containers, @NotNull ArrayList<String> accessors, @NotNull ArrayList<String> managers) {
        this.claim.getPermissions(builders, containers, accessors, managers);
    }
}

