/*
 * Decompiled with CFR 0.152.
 */
package com.ryderbelserion.map.hook.claims.worldguard;

import com.ryderbelserion.map.Pl3xMapExtras;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.pl3x.map.core.configuration.AbstractConfig;
import org.jetbrains.annotations.NotNull;

public final class WorldGuardConfig
extends AbstractConfig {
    @AbstractConfig.Key(value="settings.layer.label")
    @AbstractConfig.Comment(value="Label for map layer")
    public static String LAYER_LABEL = "WorldGuard";
    @AbstractConfig.Key(value="settings.layer.show-controls")
    @AbstractConfig.Comment(value="Show controls for map layer")
    public static boolean LAYER_SHOW_CONTROLS = true;
    @AbstractConfig.Key(value="settings.layer.default-hidden")
    @AbstractConfig.Comment(value="Whether map layer is hidden by default")
    public static boolean LAYER_DEFAULT_HIDDEN = false;
    @AbstractConfig.Key(value="settings.layer.update-interval")
    @AbstractConfig.Comment(value="Update interval for map layer")
    public static int LAYER_UPDATE_INTERVAL = 30;
    @AbstractConfig.Key(value="settings.layer.priority")
    @AbstractConfig.Comment(value="Priority for map layer")
    public static int LAYER_PRIORITY = 10;
    @AbstractConfig.Key(value="settings.layer.z-index")
    @AbstractConfig.Comment(value="zIndex for map layer")
    public static int LAYER_ZINDEX = 10;
    @AbstractConfig.Key(value="settings.claim.stroke.color")
    @AbstractConfig.Comment(value="Stroke color (#AARRGGBB)")
    public static String MARKER_STROKE_COLOR = "#FF00FF00";
    @AbstractConfig.Key(value="settings.claim.stroke.weight")
    @AbstractConfig.Comment(value="Stroke weight")
    public static int MARKER_STROKE_WEIGHT = 3;
    @AbstractConfig.Key(value="settings.claim.fill.color")
    @AbstractConfig.Comment(value="Fill color (#AARRGGBB)")
    public static String MARKER_FILL_COLOR = "#3300FF00";
    @AbstractConfig.Key(value="settings.claim.popup.tooltip")
    @AbstractConfig.Comment(value="Popup for claims")
    public static String MARKER_POPUP = "<span style=\"font-weight:bold;\"><regionname></span><br/>\n<owners><members><flags>";
    @AbstractConfig.Key(value="settings.claim.popup.owners")
    @AbstractConfig.Comment(value="Popup text for owners if present")
    public static String MARKER_POPUP_OWNERS = "Owners: <span style=\"font-weight:bold;\"><owners></span><br/>";
    @AbstractConfig.Key(value="settings.claim.popup.members")
    @AbstractConfig.Comment(value="Popup text for members if present")
    public static String MARKER_POPUP_MEMBERS = "Members: <span style=\"font-weight:bold;\"><members></span><br/>";
    @AbstractConfig.Key(value="settings.claim.popup.flags")
    @AbstractConfig.Comment(value="Popup text for flags if present")
    public static String MARKER_POPUP_FLAGS = "Flags:<br/><span style=\"display:inline-block;margin-left:10px\"><flags></span><br/>";
    @AbstractConfig.Key(value="settings.claim.popup.flag-entry")
    @AbstractConfig.Comment(value="How each flag entry should look")
    public static String MARKER_POPUP_FLAGS_ENTRY = "<span style=\"font-weight:bold;\"><flag></span>: <value>";
    @AbstractConfig.Key(value="settings.claim.regions.blacklist")
    @AbstractConfig.Comment(value="A list of regions that will not show up on the map.")
    public static List<@NotNull String> BLACKLISTED_REGIONS = new ArrayList<String>(){
        {
            this.add("example_region");
        }
    };
    private static final WorldGuardConfig CONFIG = new WorldGuardConfig();

    public static void reload() {
        Path mainDir = ((Pl3xMapExtras)Pl3xMapExtras.getPlugin(Pl3xMapExtras.class)).getDataPath();
        CONFIG.reload(mainDir.resolve("claims").resolve("worldguard.yml"), WorldGuardConfig.class);
    }
}

