/*
 * Decompiled with CFR 0.152.
 */
package com.ryderbelserion.map.hook.claims.worldguard;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.ryderbelserion.map.Pl3xMapExtras;
import com.ryderbelserion.map.hook.Hook;
import com.ryderbelserion.map.hook.claims.worldguard.WorldGuardClaim;
import com.ryderbelserion.map.hook.claims.worldguard.WorldGuardConfig;
import com.ryderbelserion.map.hook.claims.worldguard.WorldGuardLayer;
import com.ryderbelserion.map.util.ConfigUtil;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionType;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.pl3x.map.core.Keyed;
import net.pl3x.map.core.markers.Point;
import net.pl3x.map.core.markers.marker.Marker;
import net.pl3x.map.core.markers.marker.Polyline;
import net.pl3x.map.core.markers.option.Options;
import net.pl3x.map.core.util.Colors;
import net.pl3x.map.core.world.World;
import org.bukkit.Bukkit;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WorldGuardHook
implements Hook {
    private final Pl3xMapExtras plugin = (Pl3xMapExtras)JavaPlugin.getProvidingPlugin(Pl3xMapExtras.class);
    private final Cache<UUID, String> userCache = CacheBuilder.newBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build();

    public WorldGuardHook() {
        WorldGuardConfig.reload();
    }

    @Nullable
    private RegionManager getRegionManager(@NotNull World world) {
        org.bukkit.World bukkit = Bukkit.getWorld((String)world.getName());
        return bukkit == null ? null : WorldGuard.getInstance().getPlatform().getRegionContainer().get(BukkitAdapter.adapt((org.bukkit.World)bukkit));
    }

    @Override
    public void registerWorld(@NotNull World world) {
        if (this.getRegionManager(world) != null) {
            world.getLayerRegistry().register((Keyed)new WorldGuardLayer(this, world));
        }
    }

    @Override
    public void unloadWorld(@NotNull World world) {
        world.getLayerRegistry().unregister("worldguard");
    }

    @Override
    @NotNull
    public Collection<Marker<?>> getData(@NotNull World world) {
        if (!ConfigUtil.isClaimsEnabled()) {
            return EMPTY_LIST;
        }
        RegionManager manager = this.getRegionManager(world);
        if (manager == null) {
            return EMPTY_LIST;
        }
        return manager.getRegions().values().stream().filter(region -> !WorldGuardConfig.BLACKLISTED_REGIONS.contains(region.getId())).map(region -> new WorldGuardClaim(world, (ProtectedRegion)region)).filter(claim -> claim.getType() == RegionType.CUBOID || claim.getType() == RegionType.POLYGON).map(claim -> {
            String key = "wg-claim-" + claim.getID();
            Object marker = claim.getType() == RegionType.POLYGON ? Marker.polygon((String)key, (Polyline)Marker.polyline((String)(key + "line"), claim.getPoints().stream().map(point -> Point.of((int)point.getX(), (int)point.getZ())).toList())) : Marker.rectangle((String)key, (Point)claim.getMin(), (Point)claim.getMax());
            return marker.setOptions(this.getOptions((WorldGuardClaim)claim));
        }).collect(Collectors.toSet());
    }

    @NotNull
    private Options getOptions(@NotNull WorldGuardClaim claim) {
        return Options.builder().strokeWeight(Integer.valueOf(WorldGuardConfig.MARKER_STROKE_WEIGHT)).strokeColor(Integer.valueOf(Colors.fromHex((String)WorldGuardConfig.MARKER_STROKE_COLOR))).fillColor(Integer.valueOf(Colors.fromHex((String)WorldGuardConfig.MARKER_FILL_COLOR))).popupContent(this.processPopup(WorldGuardConfig.MARKER_POPUP, claim)).build();
    }

    @NotNull
    private String processPopup(@NotNull String popup, @NotNull WorldGuardClaim claim) {
        return popup.replace("<world>", claim.getWorld().getName()).replace("<regionname>", claim.getID()).replace("<owners>", this.getOwners(claim)).replace("<members>", this.getMembers(claim)).replace("<parent>", claim.getParent() == null ? "" : claim.getParent().getId()).replace("<priority>", String.valueOf(claim.getPriority())).replace("<flags>", this.getFlags(claim));
    }

    @NotNull
    private String getOwners(@NotNull WorldGuardClaim claim) {
        HashSet<String> set = new HashSet<String>();
        set.addAll(claim.getOwners().getGroups());
        set.addAll(claim.getOwners().getPlayers());
        set.addAll(claim.getOwners().getUniqueIds().stream().map(uniqueId -> {
            String username = (String)this.userCache.getIfPresent(uniqueId);
            if (username != null) {
                return username;
            }
            username = this.plugin.getServer().getOfflinePlayer(uniqueId).getName();
            if (username != null) {
                this.userCache.put(uniqueId, (Object)username);
                return username;
            }
            return uniqueId.toString();
        }).toList());
        return set.isEmpty() ? "" : WorldGuardConfig.MARKER_POPUP_OWNERS.replace("<owners>", String.join((CharSequence)", ", set));
    }

    @NotNull
    private String getMembers(@NotNull WorldGuardClaim claim) {
        HashSet<String> set = new HashSet<String>();
        set.addAll(claim.getMembers().getGroups());
        set.addAll(claim.getMembers().getPlayers());
        set.addAll(claim.getMembers().getUniqueIds().stream().map(uniqueId -> {
            String username = (String)this.userCache.getIfPresent(uniqueId);
            if (username != null) {
                return username;
            }
            username = this.plugin.getServer().getOfflinePlayer(uniqueId).getName();
            if (username != null) {
                this.userCache.put(uniqueId, (Object)username);
                return username;
            }
            return uniqueId.toString();
        }).toList());
        return set.isEmpty() ? "" : WorldGuardConfig.MARKER_POPUP_MEMBERS.replace("<members>", String.join((CharSequence)", ", set));
    }

    @NotNull
    private String getFlags(@NotNull WorldGuardClaim claim) {
        Map<Flag<?>, Object> flags = claim.getFlags();
        Set set = flags.keySet().stream().map(flag -> WorldGuardConfig.MARKER_POPUP_FLAGS_ENTRY.replace("<flag>", flag.getName()).replace("<value>", String.valueOf(flags.get(flag)))).collect(Collectors.toSet());
        return set.isEmpty() ? "" : WorldGuardConfig.MARKER_POPUP_FLAGS.replace("<flags>", String.join((CharSequence)"<br/>", set));
    }
}

