/*
 * Decompiled with CFR 0.152.
 */
package com.ryderbelserion.map.listener.banners;

import com.destroystokyo.paper.event.block.BlockDestroyEvent;
import com.ryderbelserion.map.api.enums.Permissions;
import com.ryderbelserion.map.config.BannerConfig;
import com.ryderbelserion.map.marker.banners.Banner;
import com.ryderbelserion.map.marker.banners.BannersLayer;
import com.ryderbelserion.map.marker.banners.Icon;
import com.ryderbelserion.map.marker.banners.Position;
import com.ryderbelserion.map.util.ConfigUtil;
import com.ryderbelserion.map.util.ItemUtil;
import java.util.concurrent.ThreadLocalRandom;
import net.pl3x.map.core.Pl3xMap;
import net.pl3x.map.core.world.World;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BannerListener
implements Listener {
    @EventHandler
    public void onClickBanner(@NotNull PlayerInteractEvent event) {
        if (!ConfigUtil.isBannersEnabled()) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        BlockState state = block.getState();
        if (!(state instanceof org.bukkit.block.Banner)) {
            return;
        }
        org.bukkit.block.Banner banner = (org.bukkit.block.Banner)state;
        if (event.getPlayer().getInventory().getItemInMainHand().getType() != Material.FILLED_MAP) {
            return;
        }
        if (!Permissions.banners_admin.hasPermission((CommandSender)event.getPlayer())) {
            return;
        }
        switch (event.getAction()) {
            case LEFT_CLICK_BLOCK: {
                event.setCancelled(true);
                this.tryRemoveBanner(banner);
                break;
            }
            case RIGHT_CLICK_BLOCK: {
                this.tryAddBanner((BlockState)banner);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBannerPlace(@NotNull BlockPlaceEvent event) {
        if (!ConfigUtil.isBannersEnabled() || !BannerConfig.banners_block_place) {
            return;
        }
        this.tryAddBanner(event.getBlock().getState(false));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBannerBreak(@NotNull BlockBreakEvent event) {
        if (!ConfigUtil.isBannersEnabled()) {
            return;
        }
        this.tryRemoveBanner(event.getBlock().getState(false));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBannerBreak(@NotNull BlockDestroyEvent event) {
        if (!ConfigUtil.isBannersEnabled()) {
            return;
        }
        this.tryRemoveBanner(event.getBlock().getState(false));
    }

    protected void tryAddBanner(@NotNull BlockState state) {
        if (state instanceof org.bukkit.block.Banner) {
            org.bukkit.block.Banner banner = (org.bukkit.block.Banner)state;
            Location loc = banner.getLocation();
            Position pos = new Position(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
            this.tryAddBanner(banner, pos);
        }
    }

    protected void tryAddBanner(@NotNull org.bukkit.block.Banner banner, @NotNull Position pos) {
        BannersLayer layer = this.getLayer((BlockState)banner);
        if (layer == null) {
            return;
        }
        Icon icon = Icon.get(banner.getType());
        layer.putBanner(new Banner(pos, icon, banner.getCustomName()));
        this.particles(banner.getLocation(), ItemUtil.getParticleType(layer.getConfig().BANNER_ADD_PARTICLES), ItemUtil.getSound(layer.getConfig().BANNER_ADD_SOUND));
    }

    protected void tryRemoveBanner(@NotNull BlockState state) {
        if (state instanceof org.bukkit.block.Banner) {
            org.bukkit.block.Banner banner = (org.bukkit.block.Banner)state;
            this.tryRemoveBanner(banner);
        }
    }

    protected void tryRemoveBanner(@NotNull org.bukkit.block.Banner banner) {
        BannersLayer layer = this.getLayer((BlockState)banner);
        if (layer == null) {
            return;
        }
        Location loc = banner.getLocation();
        Position pos = new Position(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
        if (!layer.containsBanner(pos)) {
            return;
        }
        layer.removeBanner(pos);
        this.particles(banner.getLocation(), ItemUtil.getParticleType(layer.getConfig().BANNER_REMOVE_PARTICLES), ItemUtil.getSound(layer.getConfig().BANNER_REMOVE_SOUND));
    }

    @Nullable
    protected BannersLayer getLayer(@NotNull BlockState state) {
        World world = (World)Pl3xMap.api().getWorldRegistry().get(state.getWorld().getName());
        if (world == null || !world.isEnabled()) {
            return null;
        }
        return (BannersLayer)world.getLayerRegistry().get("pl3xmap_banners");
    }

    protected void particles(@NotNull Location loc, @Nullable Particle particle, @Nullable Sound sound) {
        org.bukkit.World world = loc.getWorld();
        if (sound != null) {
            world.playSound(loc, sound, 1.0f, 1.0f);
        }
        if (particle != null) {
            ThreadLocalRandom rand = ThreadLocalRandom.current();
            for (int i = 0; i < 20; ++i) {
                double x = loc.getX() + rand.nextGaussian();
                double y = loc.getY() + rand.nextGaussian();
                double z = loc.getZ() + rand.nextGaussian();
                world.spawnParticle(particle, x, y, z, 1, 0.0, 0.0, 0.0, 0.0, null, true);
            }
        }
    }
}

