/*
 * Decompiled with CFR 0.152.
 */
package com.ryderbelserion.map.marker.banners;

import com.ryderbelserion.map.marker.banners.Icon;
import com.ryderbelserion.map.marker.banners.Position;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;

public record Banner(Position pos, Icon icon, String name) {
    public boolean isBanner(@NotNull World world) {
        return world.getBlockAt(this.pos().x(), this.pos().y(), this.pos().z()).getState() instanceof org.bukkit.block.Banner;
    }

    @NotNull
    public static Banner load(@NotNull DataInputStream in) throws IOException {
        return new Banner(Position.load(in), Icon.valueOf(in.readUTF()), in.readUTF());
    }

    public void save(@NotNull DataOutputStream out) throws IOException {
        this.pos().save(out);
        out.writeUTF(this.icon().name());
        out.writeUTF(this.name());
    }
}

