/*
 * Decompiled with CFR 0.152.
 */
package com.ryderbelserion.map.marker.signs;

import com.ryderbelserion.map.Pl3xMapExtras;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.imageio.ImageIO;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.pl3x.map.core.Keyed;
import net.pl3x.map.core.Pl3xMap;
import net.pl3x.map.core.image.IconImage;
import net.pl3x.map.core.registry.IconRegistry;
import org.bukkit.block.Sign;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum Icon {
    ACACIA,
    BAMBOO,
    BIRCH,
    CHERRY,
    CRIMSON,
    DARK_OAK,
    JUNGLE,
    MANGROVE,
    OAK,
    SPRUCE,
    WARPED;

    private final String name = this.name().toLowerCase(Locale.ROOT);
    private final String key = String.format("pl3xmap_%s_sign", this.name);
    @NotNull
    private static final Pl3xMapExtras plugin;
    @NotNull
    private static final Path path;
    @NotNull
    private static final ComponentLogger logger;
    private static final Map<String, Icon> BY_NAME;
    private static final Map<WoodType, Icon> BY_WOOD;

    @NotNull
    public final String getKey() {
        return this.key;
    }

    @Nullable
    public static Icon get(@NotNull Sign sign) {
        if (sign instanceof SignBlock) {
            SignBlock block = (SignBlock)sign;
            return BY_WOOD.get(block.type());
        }
        return BY_WOOD.get(WoodType.OAK);
    }

    public static void register() {
        @NotNull Path iconFolder = path.resolve("signs");
        @NotNull IconRegistry registry = Pl3xMap.api().getIconRegistry();
        for (Icon icon : Icon.values()) {
            String signFilename = String.format("icons%s%s_sign.png", File.separator, icon.name);
            String tooltipKey = String.format("pl3xmap_%s_sign_tooltip", icon.name);
            String tooltipFilename = String.format("icons%s%s_tooltip.png", File.separator, icon.name);
            try {
                registry.register((Keyed)new IconImage(icon.key, ImageIO.read(iconFolder.resolve(signFilename).toFile()), "png"));
                registry.register((Keyed)new IconImage(tooltipKey, ImageIO.read(iconFolder.resolve(tooltipFilename).toFile()), "png"));
            }
            catch (IOException exception) {
                logger.warn("Failed to register icon ({}) {}", new Object[]{icon.name, signFilename, exception});
            }
        }
    }

    static {
        plugin = (Pl3xMapExtras)JavaPlugin.getPlugin(Pl3xMapExtras.class);
        path = plugin.getDataPath();
        logger = plugin.getComponentLogger();
        BY_NAME = new HashMap<String, Icon>();
        BY_WOOD = new HashMap<WoodType, Icon>();
        Arrays.stream(Icon.values()).forEach(icon -> BY_NAME.put(icon.name, (Icon)((Object)icon)));
        WoodType.values().forEach(type -> BY_WOOD.computeIfAbsent((WoodType)type, k -> BY_NAME.get(type.name())));
    }
}

