/*
 * Decompiled with CFR 0.152.
 */
package com.ryderbelserion.map.marker.signs;

import com.ryderbelserion.map.marker.signs.Icon;
import com.ryderbelserion.map.marker.signs.Position;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;

public record Sign(@NotNull Position pos, @NotNull Icon icon, @NotNull List<String> lines) {
    public boolean isSign(@NotNull World world) {
        return world.getBlockAt(this.pos().x(), this.pos().y(), this.pos().z()).getState() instanceof org.bukkit.block.Sign;
    }

    @NotNull
    public static Sign load(@NotNull DataInputStream in) throws IOException {
        return new Sign(Position.load(in), Icon.valueOf(in.readUTF()), List.of(in.readUTF(), in.readUTF(), in.readUTF(), in.readUTF()));
    }

    public void save(@NotNull DataOutputStream out) throws IOException {
        this.pos().save(out);
        out.writeUTF(this.icon().name());
        for (String line : this.lines()) {
            out.writeUTF(line);
        }
    }
}

