/*
 * Decompiled with CFR 0.152.
 */
package com.ryderbelserion.fusion.core.files.types;

import com.ryderbelserion.fusion.core.api.enums.FileAction;
import com.ryderbelserion.fusion.core.api.enums.FileType;
import com.ryderbelserion.fusion.core.api.exceptions.FusionException;
import com.ryderbelserion.fusion.core.api.interfaces.files.ICustomFile;
import com.ryderbelserion.fusion.core.api.utils.FileUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LogCustomFile
extends ICustomFile<LogCustomFile> {
    public LogCustomFile(@NotNull Path path, @NotNull List<FileAction> actions) {
        super(path, actions);
    }

    @Override
    @NotNull
    public final LogCustomFile load() {
        if (this.isLoaded()) {
            return this;
        }
        Path path = this.getPath();
        try {
            Files.createFile(path, new FileAttribute[0]);
        }
        catch (IOException exception) {
            this.fusion.log("error", "Failed to create {}! Exception: {}", path, exception.getMessage());
        }
        return this;
    }

    @Override
    @NotNull
    public final LogCustomFile save() {
        try {
            FileUtils.compress(this.getPath(), null, "", new ArrayList<FileAction>());
        }
        catch (IOException exception) {
            throw new FusionException(String.format("Could not compress file %s!", this.getFileName()), exception);
        }
        return this;
    }

    @Override
    @NotNull
    public final LogCustomFile save(@NotNull String content, @NotNull List<FileAction> actions) {
        if (actions.contains((Object)FileAction.RELOAD_FILE)) {
            this.save();
        }
        this.load();
        FileUtils.write(this.getPath(), content);
        return this;
    }

    @Override
    @NotNull
    public final FileType getFileType() {
        return FileType.LOG;
    }
}

