/*
 * Decompiled with CFR 0.152.
 */
package com.ryderbelserion.fusion.paper.api.commands;

import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.ryderbelserion.fusion.core.api.commands.ICommandManager;
import com.ryderbelserion.fusion.paper.api.commands.objects.PaperCommand;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.plugin.lifecycle.event.LifecycleEventManager;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PaperCommandManager
extends ICommandManager<CommandSourceStack, PaperCommand> {
    private final Set<PaperCommand> commands = new HashSet<PaperCommand>();
    private final LifecycleEventManager<@NotNull Plugin> lifecycle;
    private final PluginManager pluginManager;

    public PaperCommandManager(@NotNull JavaPlugin plugin) {
        this.lifecycle = plugin.getLifecycleManager();
        this.pluginManager = plugin.getServer().getPluginManager();
    }

    @Override
    public void enable(@NotNull PaperCommand command, @Nullable String description, @NotNull List<String> aliases) {
        this.lifecycle.registerEventHandler((LifecycleEventType)LifecycleEvents.COMMANDS, event -> {
            Commands registry = (Commands)event.registrar();
            this.registerPermissions(command.getPermissionDefault(), command.getPermissions());
            this.commands.add(command);
            LiteralCommandNode root = (LiteralCommandNode)command.build();
            command.getChildren().forEach(child -> {
                this.registerPermissions(child.getPermissionDefault(), child.getPermissions());
                this.commands.add((PaperCommand)child);
                root.addChild((CommandNode)child.build());
            });
            registry.register(root, description, (Collection)aliases);
        });
    }

    @Override
    public void disable() {
        for (PaperCommand command : this.commands) {
            this.unregisterPermissions(command.getPermissions());
        }
    }

    public void unregisterPermissions(@NotNull List<String> permissions) {
        for (String node : permissions) {
            Permission permission = this.pluginManager.getPermission(node);
            if (permission == null) continue;
            this.pluginManager.removePermission(permission);
        }
    }

    public void registerPermissions(@NotNull PermissionDefault permissionDefault, @NotNull List<String> permissions) {
        for (String node : permissions) {
            Permission permission = this.pluginManager.getPermission(node);
            if (permission != null) continue;
            this.pluginManager.addPermission(new Permission(node, permissionDefault));
        }
    }
}

