/*
 * Decompiled with CFR 0.152.
 */
package com.ryderbelserion.map;

import com.ryderbelserion.fusion.paper.FusionPaper;
import com.ryderbelserion.map.BaseCommand;
import com.ryderbelserion.map.api.MetricsWrapper;
import com.ryderbelserion.map.api.enums.Permissions;
import com.ryderbelserion.map.config.PluginConfig;
import com.ryderbelserion.map.hook.Hook;
import com.ryderbelserion.map.marker.mobs.MobsManager;
import com.ryderbelserion.map.util.ConfigUtil;
import com.ryderbelserion.map.util.ModuleUtil;
import io.papermc.paper.command.brigadier.BasicCommand;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import java.util.Arrays;
import org.bukkit.permissions.Permission;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Pl3xMapExtras
extends JavaPlugin {
    private MobsManager mobsManager;
    private FusionPaper api;

    public void onEnable() {
        this.api = new FusionPaper(this.getComponentLogger(), this.getDataPath());
        this.api.enable(this);
        PluginConfig.reload();
        ModuleUtil.extract();
        ModuleUtil.findHooks();
        this.mobsManager = new MobsManager();
        ModuleUtil.toggleAll(false);
        Arrays.stream(Permissions.values()).toList().forEach(permission -> {
            Permission newPermission = new Permission(permission.getPermission(), permission.getDescription(), permission.isDefault());
            this.getServer().getPluginManager().addPermission(newPermission);
        });
        this.getLifecycleManager().registerEventHandler((LifecycleEventType)LifecycleEvents.COMMANDS, event -> {
            @NotNull Commands registry = (Commands)event.registrar();
            registry.register("pl3xmapextras", "the command to handle the plugin", (BasicCommand)new BaseCommand());
        });
        new MetricsWrapper(this, 22296);
    }

    public void onDisable() {
        this.getServer().getGlobalRegionScheduler().cancelTasks((Plugin)this);
        this.getServer().getAsyncScheduler().cancelTasks((Plugin)this);
        ModuleUtil.unload();
        ModuleUtil.toggleAll(true);
        Hook.clear();
        if (this.api != null) {
            this.api.disable();
        }
    }

    @Nullable
    public final MobsManager getMobsManager() {
        if (!ConfigUtil.isMobsEnabled()) {
            this.getLogger().warning("The toggle for displaying a mob layer is turned off.");
            return null;
        }
        return this.mobsManager;
    }

    public final FusionPaper getFusion() {
        return this.api;
    }
}

