/*
 * Decompiled with CFR 0.152.
 */
package com.ryderbelserion.map.config;

import com.ryderbelserion.fusion.core.FusionProvider;
import com.ryderbelserion.fusion.core.api.FusionCore;
import com.ryderbelserion.map.util.ConfigUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Map;
import javax.imageio.ImageIO;
import libs.org.simpleyaml.configuration.ConfigurationSection;
import net.pl3x.map.core.Keyed;
import net.pl3x.map.core.Pl3xMap;
import net.pl3x.map.core.configuration.AbstractConfig;
import net.pl3x.map.core.image.IconImage;
import net.pl3x.map.core.markers.Point;
import net.pl3x.map.core.markers.Vector;
import net.pl3x.map.core.markers.option.Tooltip;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class WarpsConfig
extends AbstractConfig {
    private static final FusionCore provider = FusionProvider.get();
    private static final Path path = provider.getPath();

    public static void registerIcon(@NotNull String image) {
        if (!ConfigUtil.isWarpsEnabled()) {
            return;
        }
        String fileName = String.format("icons%s%s.png", File.separator, image);
        File icon = path.resolve("warps").resolve(fileName).toFile();
        try {
            String key = String.format("pl3xmap_warps_%s", image);
            Pl3xMap.api().getIconRegistry().register((Keyed)new IconImage(key, ImageIO.read(icon), "png"));
        }
        catch (IOException exception) {
            provider.log("warn", "Failed to register icon ({}) {}, {}", image, fileName, exception.getMessage());
            exception.printStackTrace();
        }
    }

    @Nullable
    protected Object get(@NotNull String path) {
        Object value = this.getConfig().get(path);
        if (value == null) {
            return null;
        }
        switch (path) {
            case "marker.icon.size": 
            case "marker.icon.anchor": 
            case "marker.icon.shadow-size": 
            case "marker.icon.shadow-anchor": {
                if (value instanceof ConfigurationSection) {
                    ConfigurationSection section = (ConfigurationSection)value;
                    return Vector.of((double)section.getDouble("x"), (double)section.getDouble("z"));
                }
                if (!(value instanceof Map)) break;
                Map vector = (Map)value;
                return Vector.of((double)((Double)vector.get("x")), (double)((Double)vector.get("z")));
            }
            case "marker.tooltip.offset": 
            case "marker.popup.offset": 
            case "marker.popup.auto-pan.padding.all": 
            case "marker.popup.auto-pan.padding.top-left": 
            case "marker.popup.auto-pan.padding.bottom-right": {
                if (value instanceof ConfigurationSection) {
                    ConfigurationSection section = (ConfigurationSection)value;
                    return Point.of((int)section.getInt("x"), (int)section.getInt("z"));
                }
                if (!(value instanceof Map)) break;
                Map point = (Map)value;
                return Point.of((int)((Integer)point.get("x")), (int)((Integer)point.get("z")));
            }
            case "marker.tooltip.direction": {
                return Tooltip.Direction.valueOf((String)String.valueOf(value).toUpperCase(Locale.ROOT));
            }
        }
        return super.get(path);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void set(@NotNull String path, @Nullable Object value) {
        if (value instanceof Point) {
            int z;
            int x;
            Point point = (Point)value;
            try {
                int n;
                x = n = point.x();
                z = n = point.z();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            value = Map.of("x", x, "z", z);
        } else if (value instanceof Vector) {
            double z;
            double x;
            Vector vector = (Vector)value;
            {
                double d;
                x = d = vector.x();
                z = d = vector.z();
            }
            value = Map.of("x", x, "z", z);
        } else if (value instanceof Tooltip.Direction) {
            Tooltip.Direction direction = (Tooltip.Direction)value;
            value = direction.name();
        }
        super.set(path, value);
    }
}

