/*
 * Decompiled with CFR 0.152.
 */
package com.ryderbelserion.map.hook.claims.griefdefender;

import com.griefdefender.api.claim.Claim;
import com.griefdefender.lib.flowpowered.math.vector.Vector3i;
import java.util.UUID;
import net.pl3x.map.core.markers.Point;
import net.pl3x.map.core.world.World;
import org.jetbrains.annotations.NotNull;

public class GriefDefenderClaim {
    private final World world;
    private final Claim claim;
    private final Point min;
    private final Point max;

    public GriefDefenderClaim(@NotNull World world, @NotNull Claim claim) {
        this.world = world;
        this.claim = claim;
        Vector3i min = this.claim.getLesserBoundaryCorner();
        Vector3i max = this.claim.getGreaterBoundaryCorner();
        this.min = Point.of((int)min.getX(), (int)min.getZ());
        this.max = Point.of((int)max.getX(), (int)max.getZ());
    }

    @NotNull
    public World getWorld() {
        return this.world;
    }

    public boolean isAdminClaim() {
        return this.claim.isAdminClaim();
    }

    @NotNull
    public UUID getID() {
        return this.claim.getUniqueId();
    }

    @NotNull
    public String getOwnerName() {
        return this.claim.getOwnerName();
    }

    @NotNull
    public Point getMin() {
        return this.min;
    }

    @NotNull
    public Point getMax() {
        return this.max;
    }

    public int getArea() {
        return this.claim.getArea();
    }

    public int getWidth() {
        return this.claim.getWidth();
    }

    public int getHeight() {
        return this.claim.getHeight();
    }
}

