/*
 * Decompiled with CFR 0.152.
 */
package com.ryderbelserion.map.hook.claims.worldguard;

import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldguard.domains.DefaultDomain;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionType;
import java.util.List;
import java.util.Map;
import net.pl3x.map.core.markers.Point;
import net.pl3x.map.core.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WorldGuardClaim {
    private final World world;
    private final ProtectedRegion region;
    private final Point min;
    private final Point max;

    public WorldGuardClaim(@NotNull World world, @NotNull ProtectedRegion region) {
        this.world = world;
        this.region = region;
        BlockVector3 min = this.region.getMinimumPoint();
        BlockVector3 max = this.region.getMaximumPoint();
        this.min = Point.of((int)min.getX(), (int)min.getZ());
        this.max = Point.of((int)max.getX(), (int)max.getZ());
    }

    @NotNull
    public World getWorld() {
        return this.world;
    }

    @NotNull
    public String getID() {
        return this.region.getId();
    }

    @NotNull
    public DefaultDomain getOwners() {
        return this.region.getOwners();
    }

    @NotNull
    public DefaultDomain getMembers() {
        return this.region.getMembers();
    }

    @NotNull
    public Point getMin() {
        return this.min;
    }

    @NotNull
    public Point getMax() {
        return this.max;
    }

    @Nullable
    public ProtectedRegion getParent() {
        return this.region.getParent();
    }

    public int getPriority() {
        return this.region.getPriority();
    }

    @NotNull
    public Map<Flag<?>, Object> getFlags() {
        return this.region.getFlags();
    }

    @NotNull
    public List<BlockVector2> getPoints() {
        return this.region.getPoints();
    }

    @NotNull
    public RegionType getType() {
        return this.region.getType();
    }
}

