/*
 * Decompiled with CFR 0.152.
 */
package com.ryderbelserion.map.listener.mobs;

import com.ryderbelserion.map.Pl3xMapExtras;
import com.ryderbelserion.map.config.MobConfig;
import com.ryderbelserion.map.marker.mobs.Icon;
import com.ryderbelserion.map.marker.mobs.MobsLayer;
import com.ryderbelserion.map.marker.mobs.MobsManager;
import com.ryderbelserion.map.util.ConfigUtil;
import net.pl3x.map.core.Keyed;
import net.pl3x.map.core.Pl3xMap;
import net.pl3x.map.core.event.EventHandler;
import net.pl3x.map.core.event.EventListener;
import net.pl3x.map.core.event.server.Pl3xMapEnabledEvent;
import net.pl3x.map.core.event.server.ServerLoadedEvent;
import net.pl3x.map.core.event.world.WorldLoadedEvent;
import net.pl3x.map.core.event.world.WorldUnloadedEvent;
import net.pl3x.map.core.world.World;
import org.bukkit.event.Listener;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MobWorldListener
implements EventListener,
Listener {
    @NotNull
    private final Pl3xMapExtras plugin = (Pl3xMapExtras)JavaPlugin.getPlugin(Pl3xMapExtras.class);
    @Nullable
    private final MobsManager mobsManager = this.plugin.getMobsManager();

    public MobWorldListener() {
        if (!ConfigUtil.isMobsEnabled()) {
            return;
        }
        Pl3xMap.api().getEventRegistry().register((EventListener)this);
    }

    @EventHandler
    public void onPl3xMapEnabled(@NotNull Pl3xMapEnabledEvent event) {
        if (!ConfigUtil.isMobsEnabled()) {
            return;
        }
        Icon.register();
    }

    @EventHandler
    public void onServerLoaded(@NotNull ServerLoadedEvent event) {
        if (!ConfigUtil.isMobsEnabled()) {
            return;
        }
        Icon.register();
        Pl3xMap.api().getWorldRegistry().forEach(this::registerWorld);
    }

    @EventHandler
    public void onWorldLoaded(@NotNull WorldLoadedEvent event) {
        if (!ConfigUtil.isMobsEnabled()) {
            return;
        }
        this.registerWorld(event.getWorld());
    }

    @EventHandler
    public void onWorldUnloaded(@NotNull WorldUnloadedEvent event) {
        if (!ConfigUtil.isMobsEnabled() || this.mobsManager == null) {
            return;
        }
        try {
            this.mobsManager.clearMarkers(event.getWorld().getName());
            event.getWorld().getLayerRegistry().unregister("pl3xmap_mobs");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void registerWorld(@NotNull World world) {
        if (this.mobsManager == null) {
            return;
        }
        this.mobsManager.addWorld(world.getName());
        world.getLayerRegistry().register((Keyed)new MobsLayer(new MobConfig(world)));
    }
}

