/*
 * Decompiled with CFR 0.152.
 */
package com.ryderbelserion.map.listener.signs;

import com.destroystokyo.paper.event.block.BlockDestroyEvent;
import com.ryderbelserion.map.api.enums.Permissions;
import com.ryderbelserion.map.marker.signs.Icon;
import com.ryderbelserion.map.marker.signs.Position;
import com.ryderbelserion.map.marker.signs.SignsLayer;
import com.ryderbelserion.map.util.ConfigUtil;
import com.ryderbelserion.map.util.ItemUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import net.pl3x.map.core.Pl3xMap;
import net.pl3x.map.core.world.World;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.block.sign.SignSide;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockDropItemEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SignListener
implements Listener {
    private final List<Location> placedSigns = new ArrayList<Location>();

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onSignEdit(@NotNull SignChangeEvent event) {
        if (!ConfigUtil.isSignsEnabled()) {
            return;
        }
        boolean placedSign = this.placedSigns.remove(event.getBlock().getLocation());
        if (!placedSign && !Permissions.signs_admin.hasPermission((CommandSender)event.getPlayer())) {
            return;
        }
        BlockState state = event.getBlock().getState(false);
        SignsLayer layer = this.getLayer(state);
        if (layer == null) {
            return;
        }
        Location loc = state.getLocation();
        Position pos = new Position(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
        if (!(placedSign && layer.getConfig().SIGN_BLOCK_PLACE || layer.hasSign(pos))) {
            return;
        }
        if (!(state instanceof Sign)) {
            return;
        }
        Sign sign = (Sign)state;
        this.tryAddSign(sign, pos, List.of(event.getLines()));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onSignBreak(@NotNull BlockDestroyEvent event) {
        if (!ConfigUtil.isSignsEnabled()) {
            return;
        }
        this.tryRemoveSign(event.getBlock().getState());
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onClickSign(@NotNull PlayerInteractEvent event) {
        if (!ConfigUtil.isSignsEnabled()) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        BlockState state = block.getState();
        if (!(state instanceof Sign)) {
            return;
        }
        Sign sign = (Sign)state;
        if (event.getPlayer().getInventory().getItemInMainHand().getType() != Material.FILLED_MAP) {
            return;
        }
        if (!Permissions.signs_admin.hasPermission((CommandSender)event.getPlayer())) {
            return;
        }
        switch (event.getAction()) {
            case LEFT_CLICK_BLOCK: {
                event.setCancelled(true);
                this.tryRemoveSign(sign);
                break;
            }
            case RIGHT_CLICK_BLOCK: {
                event.setCancelled(true);
                this.tryAddSign(sign, sign.getTargetSide(event.getPlayer()));
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onSignPlace(@NotNull BlockPlaceEvent event) {
        if (!ConfigUtil.isSignsEnabled()) {
            return;
        }
        BlockState blockState = event.getBlock().getState(false);
        if (!(blockState instanceof Sign)) {
            return;
        }
        Sign sign = (Sign)blockState;
        SignsLayer layer = this.getLayer((BlockState)sign);
        if (layer == null) {
            return;
        }
        if (!layer.getConfig().SIGN_BLOCK_PLACE) {
            return;
        }
        this.placedSigns.add(event.getBlock().getLocation());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onSignBreak(@NotNull BlockDropItemEvent event) {
        if (!ConfigUtil.isSignsEnabled()) {
            return;
        }
        this.tryRemoveSign(event.getBlockState());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onSignBreak(@NotNull BlockBurnEvent event) {
        if (!ConfigUtil.isSignsEnabled()) {
            return;
        }
        this.tryRemoveSign(event.getBlock().getState());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onSignBreak(@NotNull BlockExplodeEvent event) {
        if (!ConfigUtil.isSignsEnabled()) {
            return;
        }
        event.blockList().forEach(block -> this.tryRemoveSign(block.getState()));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onSignBreak(@NotNull EntityExplodeEvent event) {
        if (!ConfigUtil.isSignsEnabled()) {
            return;
        }
        event.blockList().forEach(block -> this.tryRemoveSign(block.getState()));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onSignBreak(@NotNull BlockPistonExtendEvent event) {
        if (!ConfigUtil.isSignsEnabled()) {
            return;
        }
        event.getBlocks().forEach(block -> this.tryRemoveSign(block.getState()));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onSignBreak(@NotNull BlockPistonRetractEvent event) {
        if (!ConfigUtil.isSignsEnabled()) {
            return;
        }
        event.getBlocks().forEach(block -> this.tryRemoveSign(block.getState()));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onSignBreak(@NotNull BlockFromToEvent event) {
        if (!ConfigUtil.isSignsEnabled()) {
            return;
        }
        this.tryRemoveSign(event.getToBlock().getState());
    }

    private void tryAddSign(@NotNull Sign sign, @NotNull SignSide side) {
        Location loc = sign.getLocation();
        Position pos = new Position(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
        this.tryAddSign(sign, pos, this.getLines(side));
    }

    private void tryAddSign(@NotNull Sign sign, @NotNull Position pos, List<String> lines) {
        SignsLayer layer = this.getLayer((BlockState)sign);
        if (layer == null) {
            return;
        }
        Icon icon = Icon.get(sign);
        if (icon == null) {
            return;
        }
        layer.putSign(new com.ryderbelserion.map.marker.signs.Sign(pos, icon, lines));
        this.particles(sign.getLocation(), ItemUtil.getParticleType(layer.getConfig().SIGN_ADD_PARTICLES), ItemUtil.getSound(layer.getConfig().SIGN_ADD_SOUND));
    }

    protected void tryRemoveSign(@NotNull BlockState state) {
        if (state instanceof Sign) {
            Sign sign = (Sign)state;
            this.tryRemoveSign(sign);
        }
    }

    private void tryRemoveSign(@NotNull Sign sign) {
        this.placedSigns.remove(sign.getLocation());
        SignsLayer layer = this.getLayer((BlockState)sign);
        if (layer == null) {
            return;
        }
        Location loc = sign.getLocation();
        Position pos = new Position(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
        layer.removeSign(pos);
        this.particles(sign.getLocation(), ItemUtil.getParticleType(layer.getConfig().SIGN_REMOVE_PARTICLES), ItemUtil.getSound(layer.getConfig().SIGN_REMOVE_SOUND));
    }

    protected List<String> getLines(@NotNull SignSide side) {
        return List.of(side.getLines());
    }

    @Nullable
    protected SignsLayer getLayer(@NotNull BlockState state) {
        World world = (World)Pl3xMap.api().getWorldRegistry().get(state.getWorld().getName());
        if (world == null || !world.isEnabled()) {
            return null;
        }
        return (SignsLayer)world.getLayerRegistry().get("pl3xmap_signs");
    }

    protected void particles(@NotNull Location loc, @Nullable Particle particle, @Nullable Sound sound) {
        org.bukkit.World world = loc.getWorld();
        if (sound != null) {
            world.playSound(loc, sound, 1.0f, 1.0f);
        }
        if (particle != null) {
            ThreadLocalRandom rand = ThreadLocalRandom.current();
            for (int i = 0; i < 20; ++i) {
                double x = loc.getX() + rand.nextGaussian();
                double y = loc.getY() + rand.nextGaussian();
                double z = loc.getZ() + rand.nextGaussian();
                world.spawnParticle(particle, x, y, z, 1, 0.0, 0.0, 0.0, 0.0, null, true);
            }
        }
    }
}

