/*
 * Decompiled with CFR 0.152.
 */
package com.ryderbelserion.map.listener.warps;

import com.ryderbelserion.map.hook.Hook;
import com.ryderbelserion.map.util.ConfigUtil;
import com.ryderbelserion.map.util.ModuleUtil;
import net.pl3x.map.core.Pl3xMap;
import net.pl3x.map.core.event.EventHandler;
import net.pl3x.map.core.event.EventListener;
import net.pl3x.map.core.event.server.Pl3xMapEnabledEvent;
import net.pl3x.map.core.event.server.ServerLoadedEvent;
import net.pl3x.map.core.event.world.WorldLoadedEvent;
import net.pl3x.map.core.event.world.WorldUnloadedEvent;
import net.pl3x.map.core.world.World;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.jetbrains.annotations.NotNull;

public class WarpListener
implements EventListener,
Listener {
    public WarpListener() {
        if (!ConfigUtil.isWarpsEnabled()) {
            return;
        }
        Pl3xMap.api().getEventRegistry().register((EventListener)this);
    }

    @org.bukkit.event.EventHandler
    public void onPluginEnabled(@NotNull PluginEnableEvent event) {
        if (!ConfigUtil.isWarpsEnabled()) {
            return;
        }
        Hook.add(event.getPlugin().getName());
    }

    @org.bukkit.event.EventHandler
    public void onPluginDisabled(@NotNull PluginDisableEvent event) {
        if (!ConfigUtil.isWarpsEnabled()) {
            return;
        }
        Hook.remove(event.getPlugin().getName());
    }

    @EventHandler
    public void onPl3xMapEnabled(@NotNull Pl3xMapEnabledEvent event) {
        if (!ConfigUtil.isWarpsEnabled()) {
            return;
        }
        ModuleUtil.reload();
    }

    @EventHandler
    public void onServerLoaded(@NotNull ServerLoadedEvent event) {
        if (!ConfigUtil.isWarpsEnabled()) {
            return;
        }
        ModuleUtil.reload();
        Pl3xMap.api().getWorldRegistry().forEach(this::registerWorld);
    }

    @EventHandler
    public void onWorldLoaded(@NotNull WorldLoadedEvent event) {
        if (!ConfigUtil.isWarpsEnabled()) {
            return;
        }
        this.registerWorld(event.getWorld());
    }

    @EventHandler
    public void onWorldUnloaded(@NotNull WorldUnloadedEvent event) {
        if (!ConfigUtil.isWarpsEnabled()) {
            return;
        }
        try {
            Hook.hooks().forEach(hook -> hook.unloadWorld(event.getWorld()));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void registerWorld(@NotNull World world) {
        Hook.hooks().forEach(hook -> hook.registerWorld(world));
    }
}

