/*
 * Decompiled with CFR 0.152.
 */
package com.ryderbelserion.map.marker.banners;

import com.ryderbelserion.map.Pl3xMapExtras;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Locale;
import javax.imageio.ImageIO;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import net.pl3x.map.core.Keyed;
import net.pl3x.map.core.Pl3xMap;
import net.pl3x.map.core.image.IconImage;
import net.pl3x.map.core.registry.IconRegistry;
import org.bukkit.Material;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public enum Icon {
    BLACK,
    BLUE,
    BROWN,
    CYAN,
    GREEN,
    GREY,
    LIGHT_BLUE,
    LIGHT_GREY,
    LIME,
    MAGENTA,
    ORANGE,
    PINK,
    PURPLE,
    RED,
    YELLOW,
    WHITE;

    private final String key;
    private final String type = this.name().toLowerCase(Locale.ROOT);
    @NotNull
    private static final Pl3xMapExtras plugin;
    @NotNull
    private static final Path path;
    @NotNull
    private static final ComponentLogger logger;

    private Icon() {
        this.key = String.format("pl3xmap_%s_banner", this.type);
    }

    @NotNull
    public final String getKey() {
        return this.key;
    }

    @NotNull
    public static Icon get(@NotNull Material type) {
        return switch (type) {
            case Material.BLACK_BANNER, Material.BLACK_WALL_BANNER -> BLACK;
            case Material.BLUE_BANNER, Material.BLUE_WALL_BANNER -> BLUE;
            case Material.BROWN_BANNER, Material.BROWN_WALL_BANNER -> BROWN;
            case Material.CYAN_BANNER, Material.CYAN_WALL_BANNER -> CYAN;
            case Material.GREEN_BANNER, Material.GREEN_WALL_BANNER -> GREEN;
            case Material.GRAY_BANNER, Material.GRAY_WALL_BANNER -> GREY;
            case Material.LIGHT_BLUE_BANNER, Material.LIGHT_BLUE_WALL_BANNER -> LIGHT_BLUE;
            case Material.LIGHT_GRAY_BANNER, Material.LIGHT_GRAY_WALL_BANNER -> LIGHT_GREY;
            case Material.LIME_BANNER, Material.LIME_WALL_BANNER -> LIME;
            case Material.MAGENTA_BANNER, Material.MAGENTA_WALL_BANNER -> MAGENTA;
            case Material.ORANGE_BANNER, Material.ORANGE_WALL_BANNER -> ORANGE;
            case Material.PINK_BANNER, Material.PINK_WALL_BANNER -> PINK;
            case Material.PURPLE_BANNER, Material.PURPLE_WALL_BANNER -> PURPLE;
            case Material.RED_BANNER, Material.RED_WALL_BANNER -> RED;
            case Material.YELLOW_BANNER, Material.YELLOW_WALL_BANNER -> YELLOW;
            default -> WHITE;
        };
    }

    public static void register() {
        @NotNull Path iconFolder = path.resolve("banners");
        @NotNull IconRegistry registry = Pl3xMap.api().getIconRegistry();
        for (Icon icon : Icon.values()) {
            String bannerFilename = String.format("icons%s%s.png", File.separator, icon.type);
            File file = iconFolder.resolve(bannerFilename).toFile();
            try {
                registry.register((Keyed)new IconImage(icon.key, ImageIO.read(file), "png"));
            }
            catch (IOException exception) {
                logger.warn("Failed to register icon ({}) {}", new Object[]{icon.type, bannerFilename, exception});
            }
        }
    }

    static {
        plugin = (Pl3xMapExtras)JavaPlugin.getPlugin(Pl3xMapExtras.class);
        path = plugin.getDataPath();
        logger = plugin.getComponentLogger();
    }
}

