/*
 * Decompiled with CFR 0.152.
 */
package com.ryderbelserion.map.marker.mobs;

import com.ryderbelserion.map.config.MobConfig;
import com.ryderbelserion.map.marker.mobs.Icon;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.pl3x.map.core.markers.Point;
import net.pl3x.map.core.markers.Vector;
import net.pl3x.map.core.markers.marker.Marker;
import net.pl3x.map.core.markers.option.Options;
import net.pl3x.map.core.markers.option.Tooltip;
import org.bukkit.Location;
import org.bukkit.entity.Mob;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MobsManager {
    private final Map<String, Collection<Marker<?>>> activeMarkers = new ConcurrentHashMap();

    public Collection<Marker<?>> getActiveMarkers(@NotNull String worldName) {
        Collection<Marker<?>> markers = this.activeMarkers.get(worldName);
        if (markers != null) {
            return markers;
        }
        return Collections.emptySet();
    }

    public void clearMarkers(@NotNull String worldName) {
        if (this.activeMarkers.isEmpty() || worldName.isBlank()) {
            return;
        }
        this.activeMarkers.remove(worldName);
    }

    public void clearAll() {
        this.activeMarkers.clear();
    }

    public void addWorld(@NotNull String worldName) {
        if (this.activeMarkers.containsKey(worldName)) {
            return;
        }
        this.activeMarkers.put(worldName, new HashSet());
    }

    public void addMarker(@NotNull String key, @NotNull Mob mob, @NotNull MobConfig config) {
        net.pl3x.map.core.markers.marker.Icon icon = this.getIcon(key, mob, config);
        this.removeMarker(mob);
        this.activeMarkers.get(mob.getWorld().getName()).add((Marker<?>)icon);
    }

    public void removeMarker(@NotNull Mob mob) {
        String worldName = mob.getWorld().getName();
        String key = String.format("%s_%s_%s", "pl3xmap_mobs", worldName, mob.getUniqueId());
        if (!this.activeMarkers.containsKey(worldName)) {
            return;
        }
        this.activeMarkers.get(worldName).removeIf(marker -> marker.getKey().equals(key));
    }

    @NotNull
    private String mob(@NotNull Mob mob) {
        @Nullable Component name = mob.customName();
        return name == null ? mob.getName() : PlainTextComponentSerializer.plainText().serialize(name);
    }

    @NotNull
    private Point point(@NotNull Location loc) {
        return Point.of((int)loc.getBlockX(), (int)loc.getBlockZ());
    }

    public net.pl3x.map.core.markers.marker.Icon getIcon(@NotNull String key, @NotNull Mob mob, @NotNull MobConfig config) {
        return (net.pl3x.map.core.markers.marker.Icon)Marker.icon((String)key, (Point)this.point(mob.getLocation()), (String)Icon.get(mob).getKey(), (Vector)config.ICON_SIZE).setOptions(Options.builder().tooltipDirection(Tooltip.Direction.TOP).tooltipContent(config.ICON_TOOLTIP_CONTENT.replace("<mob-id>", this.mob(mob))).build());
    }
}

