/*
 * Decompiled with CFR 0.152.
 */
package com.ryderbelserion.map.util;

import com.ryderbelserion.map.hook.claims.Region;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.pl3x.map.core.markers.Point;
import net.pl3x.map.core.markers.marker.Marker;
import net.pl3x.map.core.markers.marker.Polygon;
import net.pl3x.map.core.markers.marker.Polyline;
import org.jetbrains.annotations.NotNull;

public class ChunkUtil {
    @NotNull
    public static Polygon getPoly(@NotNull String key, @NotNull Collection<? extends Region> regions) {
        Area area = new Area();
        for (Region region : regions) {
            int minX = region.minX();
            int maxX = region.maxX();
            int minZ = region.minZ();
            int maxZ = region.maxZ();
            Path2D.Double path = new Path2D.Double();
            ((Path2D)path).moveTo(minX, minZ);
            ((Path2D)path).lineTo(minX, maxZ);
            ((Path2D)path).lineTo(maxX, maxZ);
            ((Path2D)path).lineTo(maxX, minZ);
            path.closePath();
            area.add(new Area(path));
        }
        return Marker.polygon((String)key, ChunkUtil.toLines(key, area));
    }

    @NotNull
    private static List<Polyline> toLines(@NotNull String key, @NotNull Shape shape) {
        ArrayList<Polyline> lines = new ArrayList<Polyline>();
        Polyline line = new Polyline(key, Point.ZERO);
        double[] coords = new double[6];
        PathIterator iter = shape.getPathIterator(null, 1.0);
        while (!iter.isDone()) {
            switch (iter.currentSegment(coords)) {
                case 0: {
                    line = new Polyline(key, Point.of((double)coords[0], (double)coords[1]));
                    break;
                }
                case 1: {
                    line.addPoint(Point.of((double)coords[0], (double)coords[1]));
                    break;
                }
                case 4: {
                    lines.add(line);
                }
            }
            iter.next();
        }
        return lines;
    }
}

